/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.tree;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.AddressNotInTreeBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.tree.AbstractMetaTrick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.List;

public class RemoveSubtreeTrick
extends AbstractMetaTrick<RemoveSubtreeTrick> {
    public RemoveSubtreeTrick() {
        super(Pattern.of(6, 3, 0, 4, 8, 5, 2, 4, 6, 7, 8), Signature.of(FragmentType.SPELL_PART, ADDRESS, RemoveSubtreeTrick::remove));
    }

    public Fragment remove(SpellContext ctx, SpellPart spell, List<NumberFragment> address) throws BlunderException {
        SpellPart newSpell = spell.deepClone();
        SpellPart prev = null;
        SpellPart node = newSpell;
        for (NumberFragment index : address) {
            List<SpellPart> subParts = node.subParts;
            if (subParts.size() > index.asInt()) {
                SpellPart newNode = subParts.get(index.asInt());
                prev = node;
                node = newNode;
                continue;
            }
            throw new AddressNotInTreeBlunder(this, address);
        }
        if (prev == null) {
            return VoidFragment.INSTANCE;
        }
        prev.subParts.remove(address.getLast().asInt());
        return newSpell;
    }
}

