/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.vector;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.DistortionTrick;
import dev.enjarai.trickster.spell.type.Signature;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class AlignVectorTrick
extends DistortionTrick<AlignVectorTrick> {
    public AlignVectorTrick() {
        super(Pattern.of(6, 4, 1, 2, 4, 5), Signature.of(FragmentType.VECTOR, AlignVectorTrick::align));
    }

    public Fragment align(SpellContext ctx, VectorFragment vec) throws BlunderException {
        Vector3dc vector = vec.vector();
        double absX = Math.abs(vector.x());
        double absY = Math.abs(vector.y());
        double absZ = Math.abs(vector.z());
        if (absX == 0.0 && absY == 0.0 && absZ == 0.0) {
            return VectorFragment.ZERO;
        }
        if (absX >= absY && absX >= absZ) {
            return new VectorFragment((Vector3dc)new Vector3d(vector.x(), 0.0, 0.0).normalize());
        }
        if (absY >= absX && absY >= absZ) {
            return new VectorFragment((Vector3dc)new Vector3d(0.0, vector.y(), 0.0).normalize());
        }
        return new VectorFragment((Vector3dc)new Vector3d(0.0, 0.0, vector.z()).normalize());
    }
}

