/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class AbstractListArgType<F extends Fragment, T>
implements ArgType<List<F>> {
    protected final T[] types;

    protected AbstractListArgType(T[] types) {
        this.types = types;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return FragmentType.LIST.argc(fragments);
    }

    @Override
    public List<F> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        ListFragment list = (ListFragment)FragmentType.LIST.compose((Trick)trick, ctx, (List)fragments);
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (Fragment fragment : list.fragments()) {
            result.add(fragment);
        }
        return result;
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        if (!FragmentType.LIST.match(fragments)) {
            return false;
        }
        List<Fragment> list = ((ListFragment)fragments.get(0)).fragments();
        if (list.size() % this.types.length != 0) {
            return false;
        }
        int offset = 0;
        for (Fragment fragment : list) {
            if (!this.matchType(this.types[offset % this.types.length], fragment)) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    protected abstract boolean matchType(T var1, Fragment var2);

    @Override
    public class_5250 asText() {
        class_5250 text = class_2561.method_43470((String)"[");
        for (int i = 0; i < this.types.length; ++i) {
            T type = this.types[i];
            if (i > 0) {
                text = text.method_27693(", ");
            }
            text = text.method_10852((class_2561)this.typeAsText(type));
        }
        return text.method_27693("]");
    }

    protected abstract class_5250 typeAsText(T var1);
}

