/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.MapFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class AbstractMapArgType<K extends Fragment, V extends Fragment, KT extends T, VT extends T, T>
implements ArgType<HashMap<K, V>> {
    protected final KT keyType;
    protected final VT valueType;

    public AbstractMapArgType(KT keyType, VT valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return FragmentType.MAP.argc(fragments);
    }

    @Override
    public HashMap<K, V> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        MapFragment map = (MapFragment)FragmentType.MAP.compose((Trick)trick, ctx, (List)fragments);
        HashMap result = HashMap.empty();
        for (Tuple2 entry : map.map()) {
            result = result.put((Object)((Fragment)entry._1), (Object)((Fragment)entry._2));
        }
        return result;
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        if (!FragmentType.MAP.match(fragments)) {
            return false;
        }
        MapFragment map = (MapFragment)fragments.get(0);
        for (Tuple2 entry : map.map()) {
            if (!this.matchType(this.keyType, (Fragment)entry._1)) {
                return false;
            }
            if (this.matchType(this.valueType, (Fragment)entry._2)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean matchType(T var1, Fragment var2);

    @Override
    public class_5250 asText() {
        return class_2561.method_43470((String)"{ ").method_10852((class_2561)this.typeAsText(this.keyType)).method_27693(": ").method_10852((class_2561)this.typeAsText(this.valueType)).method_27693(" }");
    }

    protected abstract class_5250 typeAsText(T var1);
}

