/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class AbstractVariadicArgType<F extends Fragment, T>
implements ArgType<List<F>> {
    protected final T[] types;
    protected final boolean require;
    protected final boolean unpack;

    protected AbstractVariadicArgType(T[] types, boolean require, boolean unpack) {
        this.types = types;
        this.require = require;
        this.unpack = unpack;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return fragments.size() - fragments.size() % this.types.length;
    }

    @Override
    public List<F> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        Object object;
        if (this.unpack && !fragments.isEmpty() && (object = fragments.getFirst()) instanceof ListFragment) {
            ListFragment list = (ListFragment)object;
            fragments = list.fragments();
        }
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (Fragment fragment : fragments) {
            result.add(fragment);
        }
        return result;
    }

    public abstract AbstractVariadicArgType<F, T> require();

    public abstract AbstractVariadicArgType<F, T> unpack();

    @Override
    public boolean match(List<Fragment> fragments) {
        Object object;
        if (this.unpack && !fragments.isEmpty() && (object = fragments.getFirst()) instanceof ListFragment) {
            ListFragment list = (ListFragment)object;
            fragments = list.fragments();
        }
        if (this.require && fragments.isEmpty()) {
            return false;
        }
        if (fragments.size() % this.types.length != 0) {
            return false;
        }
        int offset = 0;
        for (Fragment fragment : fragments) {
            if (!this.matchType(this.types[offset % this.types.length], fragment)) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    protected abstract boolean matchType(T var1, Fragment var2);

    protected class_5250 appendTypesText(class_5250 text) {
        for (int i = 0; i < this.types.length; ++i) {
            T type = this.types[i];
            if (i > 0) {
                text = text.method_27693(", ");
            }
            text = text.method_10852((class_2561)this.typeAsText(type));
        }
        return text;
    }

    @Override
    public class_5250 asText() {
        class_5250 text = this.types.length == 1 ? this.typeAsText(this.types[0]).method_27693("...") : this.appendTypesText(class_2561.method_43470((String)"(")).method_27693(")...");
        if (this.unpack) {
            text = this.appendTypesText(text.method_27693(" | [")).method_27693("]");
        }
        return text;
    }

    protected abstract class_5250 typeAsText(T var1);
}

