/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.util;

import dev.enjarai.trickster.spell.EnterScopeInstruction;
import dev.enjarai.trickster.spell.ExitScopeInstruction;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellInstruction;
import dev.enjarai.trickster.spell.SpellPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Stack;

public class SpellUtils {
    public static SpellPart decodeInstructions(Stack<SpellInstruction> instructions, Stack<Integer> scope, Stack<Fragment> inputs, Optional<Fragment> overrideReturnValue) {
        Stack<SpellPart> children = new Stack<SpellPart>();
        instructions = (Stack)instructions.clone();
        scope = (Stack)scope.clone();
        for (Fragment input : inputs) {
            children.push(new SpellPart(input));
        }
        while (instructions.size() > 0) {
            SpellInstruction inst = (SpellInstruction)instructions.pop();
            if (inst instanceof EnterScopeInstruction) {
                scope.push(0);
                continue;
            }
            if (inst instanceof ExitScopeInstruction) {
                scope.pop();
                if (scope.isEmpty()) continue;
                scope.push((Integer)scope.pop() + 1);
                continue;
            }
            ArrayList<SpellPart> _args = new ArrayList<SpellPart>();
            for (int i = ((Integer)scope.peek()).intValue(); i > 0; --i) {
                _args.add((SpellPart)children.pop());
            }
            SequencedCollection args = _args.reversed();
            children.push(new SpellPart((Fragment)inst, (List<SpellPart>)args));
        }
        return overrideReturnValue.map(fragment -> new SpellPart((Fragment)fragment, (List<SpellPart>)new ArrayList(children).reversed())).orElse((SpellPart)children.pop());
    }

    public static Stack<SpellInstruction> flattenNode(SpellPart head) {
        Stack<SpellInstruction> instructions = new Stack<SpellInstruction>();
        Stack<SpellPart> headStack = new Stack<SpellPart>();
        Stack<Integer> indexStack = new Stack<Integer>();
        headStack.push(head);
        indexStack.push(-1);
        while (!headStack.isEmpty()) {
            SpellPart currentNode = (SpellPart)headStack.peek();
            int currentIndex = (Integer)indexStack.pop();
            if (currentIndex == -1) {
                instructions.push(new ExitScopeInstruction());
                instructions.push(currentNode.glyph);
            }
            if (++currentIndex < currentNode.subParts.size()) {
                headStack.push((SpellPart)currentNode.subParts.reversed().get(currentIndex));
                indexStack.push(currentIndex);
                indexStack.push(-1);
                continue;
            }
            headStack.pop();
            instructions.push(new EnterScopeInstruction());
        }
        return instructions;
    }
}

