```json
{
  "title": "2. The Basics of Mana",
  "icon": "minecraft:paper",
  "ordinal": 1,
  "category": "trickster:tutorials"
}
```

To be able to do any proper spellcasting, you'll need access to **Mana**.
Any spell that affects the world will consume a certain amount of Mana, scaling significantly for larger effects.


Amounts of Mana can be measured in Gandalfs, or G, named after a certain famous wizard. 

;;;;;

One Gandalf is defined as the amount of magical energy required to light a candle.
As such, many spell costs will be measured in kiloGandalfs, or kG, 
since one Gandalf by itself is a very small amount.



Mana can be persistently stored in Knots, like the one below:
<|item-spotlight@lavender:book_components|item=trickster:amethyst_knot|>

;;;;;

These gemstones encased in glass orbs hold a certain 
amount of Mana based on the rarity of the gem they're made from.
Some gems also have unique properties when made into a Knot, such as Amethyst, 
which, unlike other gems, already contains Mana when converted, 
but cannot be refilled by any known means.


This makes Amethyst Knots a great source of Mana to get started with,
or when in a pinch.

;;;;;

<|item-spotlight@lavender:book_components|item=trickster:emerald_knot|>Most Knots, though, can be refilled by simply exposing them to the night sky.
Either by throwing them on the ground, or placing them inside a [Charging Array](^trickster:items/charging_array).
Rechargeable Knots thrown on the ground will not despawn.
They will charge most quickly at or near full or new moons, but not at all on some days in between.

;;;;;

Knots also keep track of their current draw rate in their tooltip, measured in Merlins, or M.
Merlins are defined as Gandalfs per Tick, 
Ticks being the smallest unit of meaningful time, at 1/20th of a second.


For example, a spell drawing 50 M would consume 1 kiloGandalf per second.
<|item-spotlight@lavender:book_components|item=trickster:diamond_knot|>

;;;;;

To actually create a Knot, one can simply use [Ploy of the Moon Watcher](^trickster:ploys/mana#2)
while having an Amethyst and Glass Block in their inventory.
An Amethyst Knot costs no Mana to create, as it can provide its own power,
but any other Knot requires an appropriate amount of Mana to be constructed, 
as detailed [here](^trickster:concepts/mana).

;;;;;

Other Knot types will also require the caster to specify the slot containing 
the appropriate gem as a first argument, but this will be covered later.


For now, drawing the [Ploy of the Moon Watcher](^trickster:ploys/mana#2) 
in your [Mirror of Evaluation](^trickster:items/mirror_of_evaluation) 
as follows will allow you to create Amethyst Knots with ease.
Create a few of these before continuing!

;;;;;

<|spell-preview-unloadable@trickster:templates|spell=YwqT9+b/wDGjlQEAks2CzAoAAAA=|>

{gray}(Drag to pan and scroll to zoom){}
