```json
{
  "title": "4. Easier Casting",
  "icon": "minecraft:paper",
  "ordinal": 3,
  "category": "trickster:tutorials"
}
```

It's worth noting that casting spells through the Mirror of Evaluation has a few drawbacks.
Most obviously, it's a massive hassle drawing those two patterns every time.
Potentially more importantly though, any spell cast 
happening through the mirror can only execute at most *64 circles*.
That really isn't a lot!

;;;;;

This is where [Wands](^trickster:items/wand) come in.
As briefly mentioned in the first chapter, 
wands execute any spell inscribed onto them when right-clicked.


What's inscribing you may ask? Actually, you've already partially interacted with it.
[Notulist's Delusion](^trickster:tricks/basic#3), used in chapter two, is used to read an inscribed spell from an item.
This works on Scrolls because a spell written on them technically counts as being inscribed.

;;;;;

Spells can actually be inscribed onto *any* item, 
though only Scrolls and Mirrors let you directly edit them.


Writing a spell to an item can be done by using [Notulist's Ploy](^trickster:tricks/basic#4).
Similarly to [Grand Stratagem](^trickster:distortions/functions#3), it only takes one input, and provides no output.


You can use a spell like the following in a mirror to read and inscribe a spell.

;;;;;

First draw the small pattern while holding your spell, 
then swap to the item you want to inscribe, and draw the other pattern.
<|spell-preview-unloadable@trickster:templates|spell=YwyT9+bf6MPEwAhiMLo0tTIAAH43+GkTAAAA|>

;;;;;

Inscribing a spell onto a Wand will give it an enchanted glint, 
and show the inscribed spell in its tooltip.


When you use your new Wand, 
a [Spell Slot](^trickster:concepts/multi_tick) is consumed while the spell runs,
allowing the spell to run for as long as needed to complete.


Combining all this, try inscribing the following spell onto a Wand:

;;;;;

<|spell-preview@trickster:templates|spell=YwyT9+ZnYDjAwwhiMDI4dDKBRVwOMIBFOEIYGBhADCEUEQDelYOZNwAAAA==|>

Once you have it inscribed, try it out to see what it does.
After that, try looking up the tricks to see *how*!
