```json
{
  "title": "5. Spell Structure",
  "icon": "minecraft:paper",
  "ordinal": 4,
  "category": "trickster:tutorials"
}
```

While chapter two covered the basics of spell-scribing,
there are a few important elements it doesn't mention.


Most importantly, some tricks may take multiple inputs,
as seen in the example spell in the last chapter.
Unlike there though, tricks sometimes also require inputs 
to be of specific types, in a specific order.

;;;;;

The inputs a trick takes, in addition to the output it provides,
are called its **Signature**.
These signatures are used all across this book 
whenever a pattern for a trick is shown.


If you're having trouble understanding the format used for signatures,
check out [the entry explaining them in more detail](^trickster:concepts/signatures)!


**But how do we know which circle comes first?**

;;;;;

<|spell-preview-unloadable@trickster:templates|spell=YwyT9+ZnAAIW9/lWJxhgAMSx/4DEcUCWceCAcgC7HdBfPgAAAA==|>

Take a look at the spell above.
Its subcircles are labelled with the order they're cast, from 0 to 3.

;;;;;

This is the same order they'll be inputted into the parent circle in.
How do we know this?
That's what the **Divider Pin** is for.


All circles with at least one subcircle will have a transparent blue 
Divider Pin somewhere on their ring.
Starting from this pin, subcircles are cast in a clockwise fashion, 
and may be numbered starting from zero.


See if you can spot the pin on this spell!

;;;;;

One last thing!
Aside from [Extensive Revision](^trickster:editing#1) and [Grafting Revision](^trickster:editing#12),
a lot of additional scribing patterns are also available,
ranging from simple conveniences to actual gamechangers.


If you haven't already, be sure to check out the [Spell-Scribing](^trickster:editing)
chapter in its entirety!