/*
 * Decompiled with CFR 0.152.
 */
package net.habb.alienevo.client.model.animation;

import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.threetag.palladium.client.model.animation.AnimationUtil;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.power.SuperpowerUtil;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.Easing;

@Environment(value=EnvType.CLIENT)
public class ChestSpinAnimation
extends PalladiumAnimation {
    private static final float DEG_PER_WALK_UNIT = 7.5f;
    private static final boolean OVERRIDE_WALK_UPDATE = true;
    private static final float MPS_TO_WALK_SPEED = 0.12f;
    private static final float WALK_SPEED_CAP = 10.0f;
    private static final class_2960 ABIL_ID = new class_2960("alienevo_aliens", "arburian_pelarota");
    private static final String ABIL_KEY_ROLL = "ball_roll";
    private static final String ABIL_KEY_PIVOT = "ball_pivot";
    private static final Map<class_742, State> STATE = new WeakHashMap<class_742, State>();

    public ChestSpinAnimation(int priority) {
        super(priority);
    }

    private static State stateOf(class_742 p) {
        return STATE.computeIfAbsent(p, k -> new State());
    }

    public void animate(PalladiumAnimation.Builder builder, class_742 player, class_572<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean isNewTickForSpin;
        State s = ChestSpinAnimation.stateOf(player);
        boolean rollEnabled = AbilityUtil.isEnabled((class_1309)player, (class_2960)ABIL_ID, (String)ABIL_KEY_ROLL);
        if (!rollEnabled && !player.method_18276() && SuperpowerUtil.hasSuperpower((class_1309)player, (class_2960)new class_2960("alienevo_aliens", "arburian_pelarota"))) {
            s.resetSpin();
            s.resetSquash();
            return;
        }
        if (rollEnabled) {
            boolean isNewTick;
            boolean bl = isNewTick = s.lastTick != player.field_6012;
            if (isNewTick) {
                s.heightDistO = s.heightDist;
                s.squashAmountO = s.squashAmount;
                double currentY = player.method_23318();
                double vy = player.method_18798().field_1351;
                if (s.lastY != currentY) {
                    if (!player.method_24828()) {
                        float easedVelocity;
                        s.squashAmount = 0.0f;
                        if (vy < 0.0) {
                            s.landingVelocity = (float)Math.abs(vy);
                        }
                        float verticalVel = (float)Math.abs(vy);
                        float targetStretch = easedVelocity = verticalVel * verticalVel * 9.0f;
                        s.heightDist = s.heightDist * 0.7f + targetStretch * 0.3f;
                        s.onGroundTimer = 0;
                    }
                    s.lastY = currentY;
                }
                boolean justLanded = !s.wasOnGround && player.method_24828();
                s.wasOnGround = player.method_24828();
                if (justLanded && s.landingVelocity > 0.1f) {
                    float velocitySquash = s.landingVelocity * 0.25f;
                    float heightSquash = s.heightDist / 25.0f;
                    float combinedSquash = velocitySquash + heightSquash;
                    s.squashAmount = class_3532.method_15363((float)combinedSquash, (float)0.02f, (float)1.2f);
                }
                if (player.method_24828() && (s.heightDist > 0.0f || s.squashAmount > 0.0f)) {
                    ++s.onGroundTimer;
                    s.heightDist *= 0.75f;
                    if (s.onGroundTimer > 1) {
                        s.squashAmount *= 0.8f;
                    }
                    if (s.heightDist < 0.01f && s.squashAmount < 0.01f) {
                        s.heightDist = 0.0f;
                        s.heightDistO = 0.0f;
                        s.squashAmount = 0.0f;
                        s.squashAmountO = 0.0f;
                        s.landingVelocity = 0.0f;
                        s.targetSquashAmount = 0.0f;
                    }
                }
            }
            float heightLerp = s.heightDistO + (s.heightDist - s.heightDistO) * partialTicks;
            float squashLerp = s.squashAmountO + (s.squashAmount - s.squashAmountO) * partialTicks;
            float scaleY = class_3532.method_15363((float)(1.0f + heightLerp / 80.0f * (1.0f - squashLerp * 0.8f)), (float)0.2f, (float)1.2f);
            float scaleXZ = class_3532.method_15363((float)((1.0f - heightLerp / 105.0f) * (1.0f + squashLerp * 0.6f)), (float)0.9f, (float)2.75f);
            builder.get(PalladiumAnimation.PlayerModelPart.BODY).scaleY(scaleY).scaleX(scaleXZ).scaleZ(scaleXZ).animate(Easing.LINEAR, 1.0f);
        }
        if (firstPersonContext.firstPerson()) {
            return;
        }
        float ball_roll = AnimationUtil.getAnimationTimerAbilityValue((class_1309)player, (class_2960)ABIL_ID, (String)ABIL_KEY_PIVOT, (float)partialTicks, (float)12.0f, (float)15.0f);
        if (ball_roll <= 0.0f) {
            s.resetSpin();
            s.justStartedSpinning = true;
            if (!player.method_18276() && SuperpowerUtil.hasSuperpower((class_1309)player, (class_2960)new class_2960("alienevo_aliens", "arburian_pelarota"))) {
                builder.get(PalladiumAnimation.PlayerModelPart.CHEST).setXRotDegrees(0.0f).animate(Easing.LINEAR, 1.0f);
            }
            return;
        }
        boolean bl = isNewTickForSpin = s.lastTick != player.field_6012;
        if (isNewTickForSpin) {
            s.phasePrev = s.phaseCurr;
            s.walkPosPrev = s.walkPosCurr;
            double dx = player.method_23317() - player.field_6014;
            double dz = player.method_23321() - player.field_5969;
            float mps = (float)Math.sqrt(dx * dx + dz * dz) * 20.0f;
            float animSpeed = class_3532.method_15363((float)(mps * 0.12f), (float)0.0f, (float)10.0f);
            player.field_42108.method_48568(animSpeed, 1.0f);
            s.walkPosCurr = player.field_42108.method_48569();
            if (s.justStartedSpinning) {
                s.walkPosPrev = s.walkPosCurr;
                s.justStartedSpinning = false;
            }
            float dPos = s.walkPosCurr - s.walkPosPrev;
            double dx2 = player.method_23317() - player.field_6014;
            double dz2 = player.method_23321() - player.field_5969;
            float yawRad = player.method_36454() * ((float)Math.PI / 180);
            float fx = -class_3532.method_15374((float)yawRad);
            float fz = class_3532.method_15362((float)yawRad);
            float forwardComp = (float)(dx2 * (double)fx + dz2 * (double)fz);
            float sign = Math.signum(forwardComp);
            s.phaseCurr += dPos * 7.5f * sign;
            if (Math.abs(s.phaseCurr) > 1000000.0f) {
                s.phaseCurr %= 360.0f;
            }
            s.lastTick = player.field_6012;
        }
        float spinDeg = class_3532.method_16439((float)partialTicks, (float)s.phasePrev, (float)s.phaseCurr) % 360.0f;
        builder.get(PalladiumAnimation.PlayerModelPart.CHEST).setXRotDegrees(spinDeg);
    }

    private static final class State {
        int lastTick = -1;
        float phasePrev = 0.0f;
        float phaseCurr = 0.0f;
        float walkPosPrev = 0.0f;
        float walkPosCurr = 0.0f;
        boolean justStartedSpinning = true;
        double lastY = 0.0;
        boolean wasOnGround = false;
        float heightDist = 0.0f;
        float heightDistO = 0.0f;
        float squashAmount = 0.0f;
        float squashAmountO = 0.0f;
        float landingVelocity = 0.0f;
        float targetSquashAmount = 0.0f;
        int onGroundTimer = 0;

        private State() {
        }

        void resetSquash() {
            this.heightDist = 0.0f;
            this.heightDistO = 0.0f;
            this.squashAmount = 0.0f;
            this.squashAmountO = 0.0f;
            this.landingVelocity = 0.0f;
            this.targetSquashAmount = 0.0f;
            this.onGroundTimer = 0;
            this.lastY = 0.0;
            this.wasOnGround = false;
        }

        void resetSpin() {
            this.phasePrev = 0.0f;
            this.phaseCurr = 0.0f;
        }
    }
}

