let wasKeyDown = {};
let activeKey = null;
let keysCurrentlyPressed = 0;

ClientEvents.tick(event => {
    let player = Client.player;
    if (!player || Client.currentScreen) return;

    let timerValue = palladium.scoreboard.getScore(player, "AlienEvo.Timer");
    if (timerValue > 0) return;

    const quickChangeKeys = [
        "QUICKCHANGE01", "QUICKCHANGE02", "QUICKCHANGE03", "QUICKCHANGE04", "QUICKCHANGE05",
        "QUICKCHANGE06", "QUICKCHANGE07", "QUICKCHANGE08", "QUICKCHANGE09", "QUICKCHANGE10"
    ];

    let currentlyPressedCount = 0;
    quickChangeKeys.forEach(keyName => {
        let key = global[keyName];
        if (!key) return;

        // Try different methods to get the bound key
        let bind = -1;
        if (typeof key.fabric_getBoundKey === 'function') {
            bind = key.fabric_getBoundKey();
        } else if (typeof key.getBoundKey === 'function') {
            bind = key.getBoundKey();
        } else if (key.key && typeof key.key.getValue === 'function') {
            bind = key.key.getValue();
        }

        // Check if key is pressed using available methods
        let isPressed = false;
        if (typeof key.isDown === 'function') {
            isPressed = key.isDown();
        } else if (typeof key.down !== 'undefined') {
            isPressed = !!key.down;
        } else if (bind !== -1 && Client.isKeyDown) {
            isPressed = Client.isKeyDown(bind);
        }

        if (isPressed) {
            currentlyPressedCount++;
        }
    });

    if (currentlyPressedCount === 0) {
        activeKey = null;
    }

    if (currentlyPressedCount === 1 && (activeKey === null || keysCurrentlyPressed !== currentlyPressedCount)) {
        quickChangeKeys.forEach(keyName => {
            let key = global[keyName];
            if (!key) return;

            // Try different methods to get the bound key
            let bind = -1;
            if (typeof key.fabric_getBoundKey === 'function') {
                bind = key.fabric_getBoundKey();
            } else if (typeof key.getBoundKey === 'function') {
                bind = key.getBoundKey();
            } else if (key.key && typeof key.key.getValue === 'function') {
                bind = key.key.getValue();
            }

            // Check if key is pressed using available methods
            let down = false;
            if (typeof key.isDown === 'function') {
                down = key.isDown();
            } else if (typeof key.down !== 'undefined') {
                down = !!key.down;
            } else if (bind !== -1 && Client.isKeyDown) {
                down = Client.isKeyDown(bind);
            }

            if (down && !wasKeyDown[keyName] && activeKey === null) {
                player.sendData('quickchange_key_pressed', { keyName: keyName });
                activeKey = keyName;
            }

            wasKeyDown[keyName] = down;
        });
    } else {
        quickChangeKeys.forEach(keyName => {
            let key = global[keyName];
            if (!key) return;

            // Try different methods to get the bound key and check state
            let down = false;
            if (typeof key.isDown === 'function') {
                down = key.isDown();
            } else if (typeof key.down !== 'undefined') {
                down = !!key.down;
            } else {
                let bind = -1;
                if (typeof key.fabric_getBoundKey === 'function') {
                    bind = key.fabric_getBoundKey();
                } else if (typeof key.getBoundKey === 'function') {
                    bind = key.getBoundKey();
                } else if (key.key && typeof key.key.getValue === 'function') {
                    bind = key.key.getValue();
                }
                if (bind !== -1 && Client.isKeyDown) {
                    down = Client.isKeyDown(bind);
                }
            }

            wasKeyDown[keyName] = down;
        });
    }

    keysCurrentlyPressed = currentlyPressedCount;
});

let wheelKeyWasDown = false;

ClientEvents.tick(event => {
   let player = Client.player;
   if (!player || Client.currentScreen) return;

   // Check if watch_state is "default", if not, don't allow wheel
   let watchState = palladium.getProperty(player, 'watch_state') || "default";
   if (watchState !== "default") return;

   let wheelKey = global["QUICKCHANGEWHEEL"];
   if (!wheelKey) return;

   // Try different methods to get the bound key
   let bind = -1;
   if (typeof wheelKey.fabric_getBoundKey === 'function') {
       bind = wheelKey.fabric_getBoundKey();
   } else if (typeof wheelKey.getBoundKey === 'function') {
       bind = wheelKey.getBoundKey();
   } else if (wheelKey.key && typeof wheelKey.key.getValue === 'function') {
       bind = wheelKey.key.getValue();
   }

   if (bind === -1) return;

   // Check if key is pressed using available methods
   let down = false;
   if (typeof wheelKey.isDown === 'function') {
       down = wheelKey.isDown();
   } else if (typeof wheelKey.down !== 'undefined') {
       down = !!wheelKey.down;
   } else if (Client.isKeyDown) {
       down = Client.isKeyDown(bind);
   }

   if (down && !wheelKeyWasDown) {
       player.sendData('quickchange_wheel_pressed', {});
   }

   wheelKeyWasDown = down;
});