/*
 * Decompiled with CFR 0.152.
 */
package net.habb.alienevo.ability;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.property.PalladiumProperties;

public class WallRunAbility
extends Ability {
    private static final double BASE_SPEED = 0.4;
    private static final double STRAFE_SCALE = 0.9;
    private static final double SPRINT_MULT = 1.35;
    private static final double AUTO_FLOW = 0.45;
    private static final double DAMP = 0.52;
    private static final double RAY_LEN = 1.6;
    private static final double MAX_HS = 0.46;
    private static final double MAX_VS = 0.46;

    public void tick(LivingEntity entity, AbilityInstance instance, IPowerHolder holder, boolean enabled) {
        double horiz;
        Vec3 surfaceVel;
        boolean hasSurfaceInput;
        if (!enabled) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_20096_() || player.m_20069_() || player.m_21255_()) {
            return;
        }
        if (!player.f_19862_) {
            return;
        }
        Vec3 look = player.m_20154_();
        Vec3 n = WallRunAbility.findWallNormalForgiving(player, look, 1.6);
        if (n == null || Math.abs(n.f_82480_) > 0.6) {
            return;
        }
        boolean w = (Boolean)PalladiumProperties.FORWARD_KEY_DOWN.get((Entity)player);
        boolean s = (Boolean)PalladiumProperties.BACKWARDS_KEY_DOWN.get((Entity)player);
        boolean a = (Boolean)PalladiumProperties.LEFT_KEY_DOWN.get((Entity)player);
        boolean d = (Boolean)PalladiumProperties.RIGHT_KEY_DOWN.get((Entity)player);
        boolean sneaking = player.m_6144_();
        Vec3 fwd = WallRunAbility.projectOnPlane(look, n);
        if (fwd.m_82556_() < 1.0E-6) {
            fwd = WallRunAbility.stableTangent(n);
        }
        fwd = fwd.m_82541_();
        Vec3 right = n.m_82537_(fwd).m_82541_();
        double inF = (w ? 1.0 : 0.0) + (s ? -1.0 : 0.0);
        double inR = (d ? 1.0 : 0.0) + (a ? -1.0 : 0.0);
        double mag = Math.hypot(inF, inR);
        boolean bl = hasSurfaceInput = mag > 1.0E-6;
        if (hasSurfaceInput) {
            inF /= mag;
            inR /= mag;
        }
        double moveAttr = player.m_21133_(Attributes.f_22279_);
        double base = 0.4 * (moveAttr / 0.1);
        if (w && player.m_20142_()) {
            base *= 1.35;
        }
        Vec3 vec3 = surfaceVel = hasSurfaceInput ? fwd.m_82490_(inF).m_82549_(right.m_82490_(inR * 0.9)).m_82541_().m_82490_(base) : fwd.m_82490_(base * 0.45);
        double vertSign = w ? 1.0 : (s || sneaking ? -1.0 : 0.0);
        Vec3 wallUp = WallRunAbility.projectOnPlane(new Vec3(0.0, 1.0, 0.0), n);
        if (wallUp.m_82556_() > 1.0E-6) {
            wallUp = wallUp.m_82541_();
        }
        Vec3 verticalVel = wallUp.m_82556_() > 0.0 ? wallUp.m_82490_(base * vertSign) : Vec3.f_82478_;
        Vec3 target = surfaceVel.m_82549_(verticalVel);
        Vec3 cur = player.m_20184_();
        Vec3 curSurface = WallRunAbility.projectOnPlane(cur, n);
        Vec3 next = new Vec3(curSurface.f_82479_ * 0.52 + target.f_82479_, curSurface.f_82480_ * 0.52 + target.f_82480_, curSurface.f_82481_ * 0.52 + target.f_82481_);
        double into = next.m_82526_(n);
        if (into < 0.0) {
            next = next.m_82546_(n.m_82490_(into));
        }
        if ((horiz = Math.hypot(next.f_82479_, next.f_82481_)) > 0.46) {
            double sclr = 0.46 / horiz;
            next = new Vec3(next.f_82479_ * sclr, next.f_82480_, next.f_82481_ * sclr);
        }
        if (next.f_82480_ > 0.46) {
            next = new Vec3(next.f_82479_, 0.46, next.f_82481_);
        }
        if (next.f_82480_ < -0.46) {
            next = new Vec3(next.f_82479_, -0.46, next.f_82481_);
        }
        player.m_20256_(next);
        player.f_19789_ = 0.0f;
    }

    private static Vec3 findWallNormalForgiving(Player p, Vec3 look, double len) {
        BlockHitResult bhr;
        Vec3 eye = p.m_146892_();
        Vec3 end = eye.m_82549_(look.m_82490_(len));
        BlockHitResult hr = p.m_9236_().m_45547_(new ClipContext(eye, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p));
        if (hr instanceof BlockHitResult && (bhr = hr).m_6662_() == HitResult.Type.BLOCK) {
            Direction d = bhr.m_82434_();
            Vec3 n = new Vec3((double)d.m_122429_(), (double)d.m_122430_(), (double)d.m_122431_()).m_82541_();
            if (Math.abs(n.f_82480_) <= 0.9) {
                return n;
            }
        }
        BlockPos base = p.m_20183_();
        Vec3 best = null;
        double bestScore = -1.0;
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            for (int dy = 0; dy <= 1; ++dy) {
                Vec3 n;
                double score;
                BlockPos pos = base.m_6630_(dy).m_121945_(dir);
                BlockState st = p.m_9236_().m_8055_(pos);
                if (!st.m_60783_((BlockGetter)p.m_9236_(), pos, dir.m_122424_()) || !((score = Math.max(0.0, (n = new Vec3((double)dir.m_122429_(), 0.0, (double)dir.m_122431_())).m_82541_().m_82526_(new Vec3(-look.f_82479_, 0.0, -look.f_82481_).m_82541_()))) > bestScore)) continue;
                bestScore = score;
                best = n;
            }
        }
        if (best != null) {
            return best.m_82541_();
        }
        Direction facing = p.m_6350_();
        Vec3 approx = new Vec3((double)facing.m_122429_(), 0.0, (double)facing.m_122431_());
        return approx.m_82556_() > 1.0E-6 ? approx.m_82541_() : null;
    }

    private static Vec3 projectOnPlane(Vec3 v, Vec3 n) {
        double dot = v.m_82526_(n);
        return new Vec3(v.f_82479_ - n.f_82479_ * dot, v.f_82480_ - n.f_82480_ * dot, v.f_82481_ - n.f_82481_ * dot);
    }

    public static Vec3 stableTangent(Vec3 n) {
        Vec3 up = Math.abs(n.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 t = up.m_82537_(n);
        if (t.m_82556_() < 1.0E-6) {
            t = new Vec3(1.0, 0.0, 0.0);
        }
        return t.m_82541_();
    }
}

