/*
 * Decompiled with CFR 0.152.
 */
package net.habb.alienevo.aliens.pyronite;

import net.habb.alienevo.client.particle.EvoParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class PyroniteBeam
extends Ability {
    public static final PalladiumProperty<Float> RANGE = new FloatProperty("range").configurable("Maximum range of the beam");
    public static final PalladiumProperty<Integer> PARTICLE_DENSITY = new IntegerProperty("particle_density").configurable("Number of particles per block distance");

    public PyroniteBeam() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42585_));
        this.withProperty(RANGE, Float.valueOf(16.0f));
        this.withProperty(PARTICLE_DENSITY, 3);
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (!entity.m_9236_().f_46443_ && enabled) {
            ServerLevel world = (ServerLevel)entity.m_9236_();
            Vec3 lookVec = entity.m_20154_().m_82541_();
            Vec3 rightVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            Vec3 forwardVec = lookVec.m_82541_();
            boolean isMainHand = entity.m_7655_() == null || entity.m_7655_().name().equals("MAIN_HAND");
            boolean isLeftHanded = false;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                isLeftHanded = player.m_5737_().name().equals("LEFT");
            }
            double handSide = isMainHand ? (isLeftHanded ? -0.4 : 0.4) : (isLeftHanded ? 0.4 : -0.4);
            Vec3 handPos = entity.m_146892_().m_82549_(rightVec.m_82490_(handSide)).m_82549_(forwardVec.m_82490_(0.9)).m_82520_(0.0, -0.23, 0.0);
            int density = (Integer)entry.getProperty(PARTICLE_DENSITY);
            double speed = 1.3;
            for (int i = 0; i < density * 45; ++i) {
                double offset = 0.25;
                double ox = (world.f_46441_.m_188500_() - 0.5) * 2.0 * offset;
                double oy = (world.f_46441_.m_188500_() - 0.5) * 2.0 * offset;
                double oz = (world.f_46441_.m_188500_() - 0.5) * 2.0 * offset;
                double velocitySpread = 0.15;
                double vx = (world.f_46441_.m_188500_() - 0.5) * 2.0 * velocitySpread;
                double vy = (world.f_46441_.m_188500_() - 0.5) * 2.0 * velocitySpread;
                double vz = (world.f_46441_.m_188500_() - 0.5) * 2.0 * velocitySpread;
                Vec3 velocity = lookVec.m_82490_(speed).m_82520_(vx, vy, vz);
                world.m_8767_((ParticleOptions)((SimpleParticleType)EvoParticleTypes.PYRONITE_FIRE.get()), handPos.f_82479_ + ox, handPos.f_82480_ + oy, handPos.f_82481_ + oz, 0, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, 1.0);
            }
        }
    }

    public String getDocumentationDescription() {
        return "Creates a concentrated beam of flame particles in the direction the entity is looking.";
    }
}

