/*
 * Decompiled with CFR 0.152.
 */
package net.habb.alienevo.client.model.animation;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.model.animation.AnimationUtil;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.power.SuperpowerUtil;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.Easing;

@OnlyIn(value=Dist.CLIENT)
public class ChestSpinAnimation
extends PalladiumAnimation {
    private static final float DEG_PER_WALK_UNIT = 7.5f;
    private static final boolean OVERRIDE_WALK_UPDATE = true;
    private static final float MPS_TO_WALK_SPEED = 0.12f;
    private static final float WALK_SPEED_CAP = 10.0f;
    private static final ResourceLocation ABIL_ID = new ResourceLocation("alienevo_aliens", "arburian_pelarota");
    private static final String ABIL_KEY_ROLL = "ball_roll";
    private static final String ABIL_KEY_PIVOT = "ball_pivot";
    private static final Map<AbstractClientPlayer, State> STATE = new WeakHashMap<AbstractClientPlayer, State>();

    public ChestSpinAnimation(int priority) {
        super(priority);
    }

    private static State stateOf(AbstractClientPlayer p) {
        return STATE.computeIfAbsent(p, k -> new State());
    }

    public void animate(PalladiumAnimation.Builder builder, AbstractClientPlayer player, HumanoidModel<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean isNewTickForSpin;
        State s = ChestSpinAnimation.stateOf(player);
        boolean rollEnabled = AbilityUtil.isEnabled((LivingEntity)player, (ResourceLocation)ABIL_ID, (String)ABIL_KEY_ROLL);
        if (!rollEnabled && !player.m_6047_() && SuperpowerUtil.hasSuperpower((LivingEntity)player, (ResourceLocation)new ResourceLocation("alienevo_aliens", "arburian_pelarota"))) {
            s.resetSpin();
            s.resetSquash();
            return;
        }
        if (rollEnabled) {
            boolean isNewTick;
            boolean bl = isNewTick = s.lastTick != player.f_19797_;
            if (isNewTick) {
                s.heightDistO = s.heightDist;
                s.squashAmountO = s.squashAmount;
                double currentY = player.m_20186_();
                double vy = player.m_20184_().f_82480_;
                if (s.lastY != currentY) {
                    if (!player.m_20096_()) {
                        float easedVelocity;
                        s.squashAmount = 0.0f;
                        if (vy < 0.0) {
                            s.landingVelocity = (float)Math.abs(vy);
                        }
                        float verticalVel = (float)Math.abs(vy);
                        float targetStretch = easedVelocity = verticalVel * verticalVel * 9.0f;
                        s.heightDist = s.heightDist * 0.7f + targetStretch * 0.3f;
                        s.onGroundTimer = 0;
                    }
                    s.lastY = currentY;
                }
                boolean justLanded = !s.wasOnGround && player.m_20096_();
                s.wasOnGround = player.m_20096_();
                if (justLanded && s.landingVelocity > 0.1f) {
                    float velocitySquash = s.landingVelocity * 0.25f;
                    float heightSquash = s.heightDist / 25.0f;
                    float combinedSquash = velocitySquash + heightSquash;
                    s.squashAmount = Mth.m_14036_((float)combinedSquash, (float)0.02f, (float)1.2f);
                }
                if (player.m_20096_() && (s.heightDist > 0.0f || s.squashAmount > 0.0f)) {
                    ++s.onGroundTimer;
                    s.heightDist *= 0.75f;
                    if (s.onGroundTimer > 1) {
                        s.squashAmount *= 0.8f;
                    }
                    if (s.heightDist < 0.01f && s.squashAmount < 0.01f) {
                        s.heightDist = 0.0f;
                        s.heightDistO = 0.0f;
                        s.squashAmount = 0.0f;
                        s.squashAmountO = 0.0f;
                        s.landingVelocity = 0.0f;
                        s.targetSquashAmount = 0.0f;
                    }
                }
            }
            float heightLerp = s.heightDistO + (s.heightDist - s.heightDistO) * partialTicks;
            float squashLerp = s.squashAmountO + (s.squashAmount - s.squashAmountO) * partialTicks;
            float scaleY = Mth.m_14036_((float)(1.0f + heightLerp / 80.0f * (1.0f - squashLerp * 0.8f)), (float)0.2f, (float)1.2f);
            float scaleXZ = Mth.m_14036_((float)((1.0f - heightLerp / 105.0f) * (1.0f + squashLerp * 0.6f)), (float)0.9f, (float)2.75f);
            builder.get(PalladiumAnimation.PlayerModelPart.BODY).scaleY(scaleY).scaleX(scaleXZ).scaleZ(scaleXZ).animate(Easing.LINEAR, 1.0f);
        }
        if (firstPersonContext.firstPerson()) {
            return;
        }
        float ball_roll = AnimationUtil.getAnimationTimerAbilityValue((LivingEntity)player, (ResourceLocation)ABIL_ID, (String)ABIL_KEY_PIVOT, (float)partialTicks, (float)12.0f, (float)15.0f);
        if (ball_roll <= 0.0f) {
            s.resetSpin();
            s.justStartedSpinning = true;
            if (!player.m_6047_() && SuperpowerUtil.hasSuperpower((LivingEntity)player, (ResourceLocation)new ResourceLocation("alienevo_aliens", "arburian_pelarota"))) {
                builder.get(PalladiumAnimation.PlayerModelPart.CHEST).setXRotDegrees(0.0f).animate(Easing.LINEAR, 1.0f);
            }
            return;
        }
        boolean bl = isNewTickForSpin = s.lastTick != player.f_19797_;
        if (isNewTickForSpin) {
            s.phasePrev = s.phaseCurr;
            s.walkPosPrev = s.walkPosCurr;
            double dx = player.m_20185_() - player.f_19854_;
            double dz = player.m_20189_() - player.f_19856_;
            float mps = (float)Math.sqrt(dx * dx + dz * dz) * 20.0f;
            float animSpeed = Mth.m_14036_((float)(mps * 0.12f), (float)0.0f, (float)10.0f);
            player.f_267362_.m_267566_(animSpeed, 1.0f);
            s.walkPosCurr = player.f_267362_.m_267756_();
            if (s.justStartedSpinning) {
                s.walkPosPrev = s.walkPosCurr;
                s.justStartedSpinning = false;
            }
            float dPos = s.walkPosCurr - s.walkPosPrev;
            double dx2 = player.m_20185_() - player.f_19854_;
            double dz2 = player.m_20189_() - player.f_19856_;
            float yawRad = player.m_146908_() * ((float)Math.PI / 180);
            float fx = -Mth.m_14031_((float)yawRad);
            float fz = Mth.m_14089_((float)yawRad);
            float forwardComp = (float)(dx2 * (double)fx + dz2 * (double)fz);
            float sign = Math.signum(forwardComp);
            s.phaseCurr += dPos * 7.5f * sign;
            if (Math.abs(s.phaseCurr) > 1000000.0f) {
                s.phaseCurr %= 360.0f;
            }
            s.lastTick = player.f_19797_;
        }
        float spinDeg = Mth.m_14179_((float)partialTicks, (float)s.phasePrev, (float)s.phaseCurr) % 360.0f;
        builder.get(PalladiumAnimation.PlayerModelPart.CHEST).setXRotDegrees(spinDeg);
    }

    private static final class State {
        int lastTick = -1;
        float phasePrev = 0.0f;
        float phaseCurr = 0.0f;
        float walkPosPrev = 0.0f;
        float walkPosCurr = 0.0f;
        boolean justStartedSpinning = true;
        double lastY = 0.0;
        boolean wasOnGround = false;
        float heightDist = 0.0f;
        float heightDistO = 0.0f;
        float squashAmount = 0.0f;
        float squashAmountO = 0.0f;
        float landingVelocity = 0.0f;
        float targetSquashAmount = 0.0f;
        int onGroundTimer = 0;

        private State() {
        }

        void resetSquash() {
            this.heightDist = 0.0f;
            this.heightDistO = 0.0f;
            this.squashAmount = 0.0f;
            this.squashAmountO = 0.0f;
            this.landingVelocity = 0.0f;
            this.targetSquashAmount = 0.0f;
            this.onGroundTimer = 0;
            this.lastY = 0.0;
            this.wasOnGround = false;
        }

        void resetSpin() {
            this.phasePrev = 0.0f;
            this.phaseCurr = 0.0f;
        }
    }
}

