/*
 * Decompiled with CFR 0.152.
 */
package net.habb.alienevo.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.habb.alienevo.client.particle.EvoParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;

public class FireParticleOptions
implements ParticleOptions {
    public static final Codec<FireParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("start_r").forGetter(o -> (int)o.sr), (App)ExtraCodecs.f_144628_.fieldOf("start_g").forGetter(o -> (int)o.sg), (App)ExtraCodecs.f_144628_.fieldOf("start_b").forGetter(o -> (int)o.sb), (App)ExtraCodecs.f_144628_.fieldOf("end_r").forGetter(o -> (int)o.er), (App)ExtraCodecs.f_144628_.fieldOf("end_g").forGetter(o -> (int)o.eg), (App)ExtraCodecs.f_144628_.fieldOf("end_b").forGetter(o -> (int)o.eb)).apply((Applicative)instance, FireParticleOptions::new));
    public static final ParticleOptions.Deserializer<FireParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<FireParticleOptions>(){

        public FireParticleOptions fromCommand(ParticleType<FireParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            String first = reader.readString();
            if (this.isHexLike(first)) {
                String hex1 = this.cleanHex(first);
                reader.expect(' ');
                String second = reader.readString();
                if (!this.isHexLike(second)) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)second);
                }
                String hex2 = this.cleanHex(second);
                float[] s = this.hexToFloats(hex1);
                float[] e = this.hexToFloats(hex2);
                return new FireParticleOptions(s[0], s[1], s[2], e[0], e[1], e[2]);
            }
            float sr = this.parseFloat(first);
            reader.expect(' ');
            float sg = reader.readFloat();
            reader.expect(' ');
            float sb = reader.readFloat();
            reader.expect(' ');
            float er = reader.readFloat();
            reader.expect(' ');
            float eg = reader.readFloat();
            reader.expect(' ');
            float eb = reader.readFloat();
            return new FireParticleOptions(sr, sg, sb, er, eg, eb);
        }

        public FireParticleOptions fromNetwork(ParticleType<FireParticleOptions> type, FriendlyByteBuf buf) {
            return new FireParticleOptions(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        private boolean isHexLike(String s) {
            String t = s.startsWith("#") ? s.substring(1) : s;
            return t.length() == 6 && t.chars().allMatch(c -> c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70);
        }

        private String cleanHex(String s) {
            return s.startsWith("#") ? s.substring(1) : s;
        }

        private float[] hexToFloats(String hex) {
            int rgb = Integer.parseInt(hex, 16);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            return new float[]{r, g, b};
        }

        private float parseFloat(String s) throws CommandSyntaxException {
            try {
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidFloat().create((Object)s);
            }
        }
    };
    public final float sr;
    public final float sg;
    public final float sb;
    public final float er;
    public final float eg;
    public final float eb;

    public FireParticleOptions(float sr, float sg, float sb, float er, float eg, float eb) {
        this.sr = sr;
        this.sg = sg;
        this.sb = sb;
        this.er = er;
        this.eg = eg;
        this.eb = eb;
    }

    public FireParticleOptions(String startHex, String endHex) {
        int s = Integer.parseInt(startHex.replace("#", ""), 16);
        int e = Integer.parseInt(endHex.replace("#", ""), 16);
        this.sr = (float)(s >> 16 & 0xFF) / 255.0f;
        this.sg = (float)(s >> 8 & 0xFF) / 255.0f;
        this.sb = (float)(s & 0xFF) / 255.0f;
        this.er = (float)(e >> 16 & 0xFF) / 255.0f;
        this.eg = (float)(e >> 8 & 0xFF) / 255.0f;
        this.eb = (float)(e & 0xFF) / 255.0f;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)EvoParticleTypes.FIRE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.sr);
        buf.writeFloat(this.sg);
        buf.writeFloat(this.sb);
        buf.writeFloat(this.er);
        buf.writeFloat(this.eg);
        buf.writeFloat(this.eb);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%f %f %f %f %f %f", Float.valueOf(this.sr), Float.valueOf(this.sg), Float.valueOf(this.sb), Float.valueOf(this.er), Float.valueOf(this.eg), Float.valueOf(this.eb));
    }
}

