/*
 * Decompiled with CFR 0.152.
 */
package net.habb.alienevo.sound;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;

public class RollSound
extends AbstractTickableSoundInstance {
    public final LivingEntity entity;
    public boolean stopRequested;
    public boolean finished = false;
    private static final int FADE_TICKS = 7;
    private int fadeInTimer = 0;
    private int fadeOutTimer = 0;
    private static final float MIN_VOLUME = 0.0f;
    private static final float MAX_VOLUME = 0.45f;
    private static final double SPEED_AT_MAX = 1.2;
    private static final float VOL_SMOOTH = 0.2f;
    private static final float BASE_PITCH = 0.35f;
    private static final float MAX_PITCH = 1.2f;
    private static final float PITCH_SMOOTH = 0.25f;
    private static final double MOVE_SILENCE_THRESHOLD = 0.02;
    private float currentVolume = 0.0f;
    private float currentPitch = 0.35f;

    public RollSound(LivingEntity entity, SoundEvent soundEvent, SoundSource category) {
        super(soundEvent, category, SoundInstance.m_235150_());
        this.entity = entity;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.0f;
        this.f_119574_ = 0.35f;
    }

    public void requestStop() {
        if (!this.stopRequested) {
            this.stopRequested = true;
            this.fadeOutTimer = 7;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7788_() {
        float fadeFactor;
        if (!this.entity.m_6084_()) {
            this.requestStop();
        }
        this.f_119575_ = (float)this.entity.m_20185_();
        this.f_119576_ = (float)this.entity.m_20186_();
        this.f_119577_ = (float)this.entity.m_20189_();
        double horizSpeed = this.entity.m_20184_().m_165924_();
        float speedNorm = (float)Math.min(horizSpeed / 1.2, 1.0);
        float shaped = (float)Math.sqrt(speedNorm);
        float targetPitch = 0.35f + 0.85f * shaped;
        this.f_119574_ = this.currentPitch = RollSound.lerp(this.currentPitch, targetPitch, 0.25f);
        float targetVolume = horizSpeed > 0.02 ? RollSound.lerp(0.0f, 0.45f, shaped) : 0.0f;
        this.currentVolume = RollSound.lerp(this.currentVolume, targetVolume, 0.2f);
        if (this.stopRequested) {
            if (this.fadeOutTimer <= 0) {
                this.finished = true;
                this.m_119609_();
                return;
            }
            fadeFactor = (float)this.fadeOutTimer / 7.0f;
            --this.fadeOutTimer;
        } else {
            if (this.fadeInTimer < 7) {
                ++this.fadeInTimer;
            }
            fadeFactor = (float)this.fadeInTimer / 7.0f;
        }
        this.f_119573_ = this.currentVolume * fadeFactor;
    }

    public boolean m_7784_() {
        return true;
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * RollSound.clamp01(t);
    }
}

