PalladiumEvents.registerAnimations((event) => {
    event.registerForPower('chroma_leap', 'afomni:crystalsapien', 200, (builder) => {
        let animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'afomni:crystalsapien', 'leap_anim', builder.getPartialTicks());
        if (animation > 0) {
            builder.get('right_arm')
                .setZRotDegrees(37.5)
                .setXRotDegrees(0)
                .animate('InOutCubic', animation);
            builder.get('left_arm')
                .setZRotDegrees(-37.5)
                .setXRotDegrees(0)
                .animate('InOutCubic', animation);
            builder.get('right_leg')
                .setX(-1.9)
                .setY(9)
                .setXRotDegrees(0)
                .setZ(-4)
                .animate('InOutCubic', animation);
            builder.get('left_leg')
                .setXRotDegrees(0)
                .animate('InOutCubic', animation);
            builder.get('body')
                .setXRotDegrees(-20)
                .animate('InOutCubic', animation);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.registerForPower('afomni/limbs', 'afomni:crystalsapien', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "afomni:crystalsapien", "crystalsapien_loop")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;
                builder.get('left_arm').rotateX(builder.getModel().leftArm.xRot * -0.1)
                builder.get('right_arm').rotateX(builder.getModel().rightArm.xRot * -0.1)
                builder.get('right_leg').rotateX(builder.getModel().rightLeg.xRot * -0.3)
                builder.get('left_leg').rotateX(builder.getModel().leftLeg.xRot * -0.3)
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.registerForPower('afomni/crystal_block', 'afomni:crystalsapien', 15, (builder) => {
        let block_anim = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'afomni:crystalsapien', 'block_abil', builder.getPartialTicks());
        if (block_anim > 0.0 && builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(90).setZRotDegrees(90).setYRotDegrees(-350).setY(9).setZ(-7).animate('InOutCubic', block_anim);
            builder.get('left_arm').setXRotDegrees(90).setZRotDegrees(-90).setYRotDegrees(350).setY(9).setZ(-7).animate('InOutCubic', block_anim);
        } else {
            builder.get('right_arm').setXRotDegrees(0).setZRotDegrees(0).setYRotDegrees(0).animate('InOutCubic', block_anim);
            builder.get('left_arm').setXRotDegrees(0).setZRotDegrees(0).setYRotDegrees(0).animate('InOutCubic', block_anim);
        }
    });
});

