/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.secondchat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.florianmichael.secondchat.filter.FilterRule;
import de.florianmichael.secondchat.filter.FilterType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SecondChat
implements ClientModInitializer {
    private static SecondChat INSTANCE;
    private final Logger logger = LogManager.getLogger((String)"SecondChat");
    private final Path config = FabricLoader.getInstance().getConfigDir().resolve("secondchat.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private List<FilterRule> rules;

    public static SecondChat instance() {
        return INSTANCE;
    }

    public void onInitializeClient() {
        INSTANCE = this;
        if (Files.exists(this.config, new LinkOption[0])) {
            try {
                FilterRule[] rules = (FilterRule[])this.gson.fromJson(Files.readString(this.config), FilterRule[].class);
                this.rules = rules == null ? new ArrayList<FilterRule>() : Arrays.stream(rules).collect(Collectors.toList());
            }
            catch (Exception e) {
                this.logger.error("Failed to read file: {}!", (Object)this.config.toString(), (Object)e);
            }
        } else {
            this.rules = new ArrayList<FilterRule>();
        }
    }

    public int getChatWidth(class_338 chatComponent) {
        int base = class_3532.method_15386((float)((float)chatComponent.method_1811() / (float)chatComponent.method_1814()));
        return base + 12;
    }

    public void save() {
        try {
            Files.write(this.config, this.gson.toJson(this.rules).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            this.logger.error("Failed to create file: {}!", (Object)this.config.toString(), (Object)e);
        }
    }

    public void add(FilterRule rule) {
        this.rules.add(rule);
        this.save();
    }

    public void remove(FilterRule rule) {
        this.rules.remove(rule);
        this.save();
    }

    public boolean matches(String input) {
        return this.rules.stream().anyMatch(rule -> switch (rule.type()) {
            default -> throw new MatchException(null, null);
            case FilterType.EQUALS -> input.equals(rule.value());
            case FilterType.EQUALS_IGNORE_CASE -> input.equalsIgnoreCase(rule.value());
            case FilterType.STARTS_WITH -> input.startsWith(rule.value());
            case FilterType.ENDS_WITH -> input.endsWith(rule.value());
            case FilterType.CONTAINS -> input.contains(rule.value());
            case FilterType.REGEX -> input.matches(rule.value());
        });
    }

    public List<FilterRule> rules() {
        return this.rules;
    }
}

