/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public abstract class CommandManager<T extends SCommand> {
    private List<T> commands;

    public Optional<T> getCommand(String entry) {
        for (SCommand command : this.commands) {
            for (String name : command.getNames()) {
                if (!entry.regionMatches(true, 0, name, 0, name.length())) continue;
                return Optional.of(command);
            }
        }
        return Optional.empty();
    }

    public List<String> getArgs(T command, String entry) {
        for (String name : ((SCommand)command).getNames()) {
            if (!entry.startsWith(name)) continue;
            entry = entry.substring(name.length());
            break;
        }
        if (entry.trim().equals("")) {
            return new ArrayList<String>();
        }
        return Arrays.asList(entry.trim().split(" "));
    }

    public Optional<String> verifArgs(@NotNull T command, List<String> args) {
        return ((SCommand)command).verify(args, false);
    }

    public Optional<String> verifCommand(String entry) {
        Optional<T> commandOpt = this.getCommand(entry);
        if (commandOpt.isPresent()) {
            return this.verifCommand((SCommand)commandOpt.get(), entry);
        }
        return Optional.empty();
    }

    public Optional<String> verifCommand(T command, String entry) {
        List<String> args = this.getArgs(command, entry);
        Optional<String> error = this.verifArgs(command, args);
        if (error.isPresent()) {
            return Optional.of("&6>> " + error.get());
        }
        return Optional.empty();
    }

    public List<String> getCommandsVerified(SPlugin sPlugin, @NotNull List<String> entries, List<String> errorList, String id) {
        ArrayList<String> result = new ArrayList<String>();
        for (String entry : entries) {
            Optional<T> commandOpt = this.getCommand(entry);
            if (commandOpt.isPresent() && !entry.contains("+++")) {
                SCommand command = (SCommand)commandOpt.get();
                Optional<String> error = this.verifCommand(command, entry);
                error.ifPresent(value -> errorList.add("&cERROR, Invalid command &7&o(Command: " + entry + ")  &7&o(ID: " + id + ") " + value));
            }
            result.add(entry);
        }
        return result;
    }

    public Map<String, String> getCommandsDisplay() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (SCommand c : this.commands) {
            ChatColor color;
            ChatColor extra = c.getExtraColor();
            if (extra == null) {
                extra = ChatColor.DARK_PURPLE;
            }
            if ((color = c.getColor()) == null) {
                color = ChatColor.LIGHT_PURPLE;
            }
            result.put(String.valueOf(extra) + "[" + String.valueOf(color) + "&l" + c.getNames().get(0) + String.valueOf(extra) + "]", c.getTemplate());
        }
        return result;
    }

    @Generated
    public List<T> getCommands() {
        return this.commands;
    }

    @Generated
    public void setCommands(List<T> commands) {
        this.commands = commands;
    }
}

