/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.utils.EntityBuilder;
import com.ssomar.score.utils.backward_compatibility.AttributeAdditionMode;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.boss.BarColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CommandSetting {
    private List<String> names;
    private int oldSystemIndex;
    private boolean oldSystemOptional = false;
    private Object type;
    private Object defaultValue;
    private final boolean DEBUG = false;
    private boolean acceptPercentage = false;
    private boolean isSlot = false;
    private boolean acceptUnderScoreForLongText = false;

    public CommandSetting(String name, int oldSystemIndex, Object type, Object defaultValue) {
        this.names = Collections.singletonList(name);
        this.oldSystemIndex = oldSystemIndex;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public CommandSetting(String name, int oldSystemIndex, Object type, Object defaultValue, boolean oldSystemOptional) {
        this.names = Collections.singletonList(name);
        this.oldSystemIndex = oldSystemIndex;
        this.type = type;
        this.defaultValue = defaultValue;
        this.oldSystemOptional = oldSystemOptional;
    }

    public CommandSetting(List<String> names, int oldSystemIndex, Object type, Object defaultValue) {
        this.names = names;
        this.oldSystemIndex = oldSystemIndex;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public CommandSetting(List<String> names, int oldSystemIndex, Object type, Object defaultValue, boolean oldSystemOptional) {
        this.names = names;
        this.oldSystemIndex = oldSystemIndex;
        this.type = type;
        this.defaultValue = defaultValue;
        this.oldSystemOptional = oldSystemOptional;
    }

    public Object getValue(String value) {
        SsomarDev.testMsg("CommandSetting getValue value: " + value + " >> type:" + String.valueOf(this.type) + " >> defaultValue: " + String.valueOf(this.defaultValue), false);
        if (value == null) {
            return this.defaultValue;
        }
        if (this.type == Double.class) {
            return Double.parseDouble(value);
        }
        if (this.type == Integer.class) {
            return Double.valueOf(value).intValue();
        }
        if (this.type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (this.type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (this.type == Enchantment.class) {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)value.toLowerCase()));
        }
        if (this.type == AttributeUtils.class) {
            return AttributeUtils.getAttribute(value);
        }
        if (this.type == AttributeAdditionMode.class) {
            try {
                return AttributeAdditionMode.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.type == EquipmentSlot.class) {
            try {
                return EquipmentSlot.valueOf((String)value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (!SCore.is1v11Less() && this.type == BarColor.class) {
            return BarColor.valueOf((String)value.toUpperCase());
        }
        if (this.type == Material.class) {
            try {
                return Material.valueOf((String)value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.type == BlockFace.class) {
            try {
                return BlockFace.valueOf((String)value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.type == UUID.class) {
            try {
                return UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.type == EntityType.class) {
            try {
                return EntityType.valueOf((String)value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.type == EntityBuilder.class) {
            return new EntityBuilder(value);
        }
        return CommandSetting.replaceUnderscoresOutsideTags(value, this.acceptUnderScoreForLongText);
    }

    public static String replaceUnderscoresOutsideTags(String value, boolean acceptUnderScoreForLongText) {
        if (acceptUnderScoreForLongText && value.contains("_") && !value.contains("http")) {
            Pattern pattern = Pattern.compile("(<[^>]+>|[^<]+)");
            Matcher matcher = pattern.matcher(value);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String part = matcher.group();
                if (!part.startsWith("<")) {
                    part = part.replace("_", " ");
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(part));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return value;
    }

    public ArgumentChecker checkValue(String value, String commandTemplate) {
        if (this.type == Double.class) {
            return SCommand.checkDouble(value, false, commandTemplate, this.acceptPercentage);
        }
        if (this.type == Integer.class) {
            if (this.isSlot) {
                return SCommand.checkSlot(value, false, commandTemplate);
            }
            return SCommand.checkInteger(value, false, commandTemplate);
        }
        if (this.type == Float.class) {
            return SCommand.checkFloat(value, false, commandTemplate, this.acceptPercentage);
        }
        if (this.type == Boolean.class) {
            return SCommand.checkBoolean(value, false, commandTemplate);
        }
        if (this.type == Enchantment.class) {
            return SCommand.checkEnchantment(value, false, commandTemplate);
        }
        if (this.type == AttributeUtils.class) {
            return SCommand.checkAttribute(value, false, commandTemplate);
        }
        if (this.type == AttributeAdditionMode.class) {
            return SCommand.checkAttributeAdditionMode(value, false, commandTemplate);
        }
        if (this.type == EquipmentSlot.class) {
            return SCommand.checkEquipmentSlot(value, false, commandTemplate);
        }
        if (!SCore.is1v11Less() && this.type == BarColor.class) {
            return SCommand.checkBarColor(value, false, commandTemplate);
        }
        if (this.type == Material.class) {
            return SCommand.checkMaterial(value, false, commandTemplate);
        }
        if (this.type == BlockFace.class) {
            return SCommand.checkBlockFace(value, false, commandTemplate);
        }
        if (this.type == UUID.class) {
            return SCommand.checkUUID(value, false, commandTemplate);
        }
        if (this.type == EntityType.class) {
            return SCommand.checkEntity(value, false, commandTemplate);
        }
        return null;
    }

    @Generated
    public List<String> getNames() {
        return this.names;
    }

    @Generated
    public int getOldSystemIndex() {
        return this.oldSystemIndex;
    }

    @Generated
    public boolean isOldSystemOptional() {
        return this.oldSystemOptional;
    }

    @Generated
    public Object getType() {
        return this.type;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isDEBUG() {
        return this.DEBUG;
    }

    @Generated
    public boolean isAcceptPercentage() {
        return this.acceptPercentage;
    }

    @Generated
    public boolean isSlot() {
        return this.isSlot;
    }

    @Generated
    public boolean isAcceptUnderScoreForLongText() {
        return this.acceptUnderScoreForLongText;
    }

    @Generated
    public void setAcceptPercentage(boolean acceptPercentage) {
        this.acceptPercentage = acceptPercentage;
    }

    @Generated
    public void setSlot(boolean isSlot) {
        this.isSlot = isSlot;
    }

    @Generated
    public void setAcceptUnderScoreForLongText(boolean acceptUnderScoreForLongText) {
        this.acceptUnderScoreForLongText = acceptUnderScoreForLongText;
    }
}

