/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.FilterManager;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;

public class RunConsoleCommand {
    static ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();

    public static void runConsoleCommand(final String command, final boolean silenceOutput) {
        final FilterManager fM = FilterManager.getInstance();
        if (silenceOutput) {
            fM.incCurrentlyInRun();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String newCommand = RunConsoleCommand.addWorldCompatibilityForExecute(command);
                    if (!newCommand.isEmpty()) {
                        Bukkit.dispatchCommand((CommandSender)console, (String)StringConverter.coloredString(newCommand));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SCore.plugin.getLogger().severe("&e[SCore] ERROR WHEN THE CONSOLE COMMAND (" + command + ") IS RUN !");
                }
            }
        };
        SCore.schedulerHook.runTask(runnable, 1L);
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (silenceOutput) {
                    fM.decrCurrentlyInRun();
                }
            }
        };
        SCore.schedulerHook.runTask(runnable3, 2L);
    }

    public static String addWorldCompatibilityForExecute(String command) {
        String[] spliter;
        if (command.contains("in <<") && (spliter = command.split("in <<")).length > 1) {
            String[] spliter2 = spliter[1].split(">>");
            final String worldName = spliter2[0];
            Optional<World> worldOptional = AllWorldManager.getWorld(worldName);
            World world = null;
            if (worldOptional.isPresent()) {
                world = worldOptional.get();
            }
            if (world != null) {
                if (SCore.isFolia()) {
                    final World worldFinal = world;
                    final String finalCommand = command;
                    BukkitRunnable runnable = new BukkitRunnable(){

                        public void run() {
                            List entities = worldFinal.getEntities();
                            if (!entities.isEmpty()) {
                                Entity entity = (Entity)entities.get(0);
                                String newCommand = finalCommand.replaceAll("in <<" + worldName + ">>", "at " + String.valueOf(entity.getUniqueId()));
                                Bukkit.dispatchCommand((CommandSender)console, (String)StringConverter.coloredString(newCommand));
                            }
                        }
                    };
                    SCore.schedulerHook.runLocationTask((Runnable)runnable, world.getSpawnLocation(), 1L);
                    return "";
                }
                List entities = world.getEntities();
                if (!entities.isEmpty()) {
                    Entity entity = (Entity)entities.get(0);
                    command = command.replaceAll("in <<" + worldName + ">>", "at " + String.valueOf(entity.getUniqueId()));
                } else {
                    return "";
                }
            }
        }
        return command;
    }
}

