/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.projectiles.SProjectile;
import com.ssomar.score.projectiles.SProjectileType;
import com.ssomar.score.projectiles.manager.SProjectilesManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Launch
extends BlockCommand {
    @Override
    public void run(Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        double speed = 2.0;
        int despawnDelay = 10;
        BlockData data = block.getBlockData();
        if (data == null || !(data instanceof Directional)) {
            return;
        }
        Directional directional = (Directional)data;
        if (args.isEmpty()) {
            this.launchProjectile(block, directional, Arrow.class, speed);
            return;
        }
        try {
            speed = Double.parseDouble(args.get(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            despawnDelay = Integer.parseInt(args.get(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Entity entity = null;
            Optional projectileOptional = null;
            SProjectile projectile = null;
            String type = args.get(0);
            if (SProjectileType.getProjectilesClasses().containsKey(type.toUpperCase())) {
                entity = this.launchProjectile(block, directional, SProjectileType.getProjectilesClasses().get(type.toUpperCase()), speed);
            } else {
                projectileOptional = SProjectilesManager.getInstance().getLoadedObjectWithID(type);
                if (projectileOptional.isPresent()) {
                    projectile = (SProjectile)projectileOptional.get();
                    entity = this.launchProjectile(block, directional, SProjectileType.getProjectilesClasses().get(((SProjectileType)((Object)((Optional)projectile.getType().getValue()).get())).getValidNames()[0]), speed);
                    Material mat = ((SProjectileType)((Object)((Optional)projectile.getType().getValue()).get())).getMaterial();
                    if (entity instanceof ThrownPotion) {
                        ThrownPotion lp = (ThrownPotion)entity;
                        ItemStack item = new ItemStack(mat, 1);
                        PotionMeta pMeta = (PotionMeta)item.getItemMeta();
                        pMeta.setColor(Color.AQUA);
                        item.setItemMeta((ItemMeta)pMeta);
                        lp.setItem(item);
                    }
                    projectile.transformTheProjectile(entity, p, mat);
                } else {
                    entity = this.launchProjectile(block, directional, Arrow.class, speed);
                }
            }
            final Entity e = entity;
            Runnable runnable = new Runnable(){
                final /* synthetic */ Launch this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (e != null) {
                        e.remove();
                    }
                }
            };
            SCore.schedulerHook.runTask(runnable, (long)despawnDelay * 20L);
            if (entity != null && SCore.hasExecutableItems && aInfo.getExecutableItem() != null) {
                ProjectileInfo pInfo = new ProjectileInfo(p, entity.getUniqueId(), Optional.ofNullable(aInfo.getExecutableItem()), aInfo.getSlot().intValue(), System.currentTimeMillis());
                ProjectilesHandler.getInstance().addProjectileInfo(pInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T extends Projectile> Entity launchProjectile(Block block, Directional directional, Class<? extends T> projectile, double speed) {
        Vector direction = directional.getFacing().getDirection();
        Location bLoc = block.getLocation().add(0.5, 0.5, 0.5);
        Entity projLaunched = block.getWorld().spawn(bLoc.add(direction.clone().multiply(0.6)), projectile);
        projLaunched.setVelocity(direction.multiply(speed));
        return projLaunched;
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        Object error = "";
        String launch = "LAUNCH {projectileType} [speed] [despawnDelay]";
        if (args.size() < 1) {
            error = "&cThere is &6not enough args &cfor the command: &e" + launch;
        }
        return ((String)error).isEmpty() ? Optional.empty() : Optional.of(error);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("LAUNCH");
        return names;
    }

    @Override
    public String getTemplate() {
        return "LAUNCH {projectileType} [speed] [despawnDelay]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

