/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Worth.WorthItem;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.usedapi.ShopGUIPlusTool;
import com.ssomar.score.usedapi.VaultAPI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SellContent
extends BlockCommand {
    private static final boolean DEBUG = true;

    public SellContent() {
        CommandSetting priceBoost = new CommandSetting("priceBoost", 0, Double.class, (Object)1.0);
        CommandSetting deleteUnsellable = new CommandSetting("deleteUnsellable", 1, Boolean.class, (Object)false);
        List<CommandSetting> settings = this.getSettings();
        settings.add(priceBoost);
        settings.add(deleteUnsellable);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(@Nullable Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        double priceBoost = (Double)sCommandToExec.getSettingValue("priceBoost");
        boolean deleteUnsellable = (Boolean)sCommandToExec.getSettingValue("deleteUnsellable");
        if (block.getState() instanceof Container && p != null) {
            Container container = (Container)block.getState();
            Inventory inv = container.getInventory();
            double amount = 0.0;
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack item = inv.getItem(i);
                if (item == null) continue;
                if (SCore.hasShopGUIPlus) {
                    double check = ShopGUIPlusTool.sellItem(p, item);
                    SsomarDev.testMsg("item : " + String.valueOf(item.getType()) + " qty: " + item.getAmount() + "check : " + check, true);
                    if (check > 0.0) {
                        amount += check;
                        ShopGUIPlusTool.registerTransaction(item, p, check, priceBoost);
                        item.setAmount(0);
                    }
                } else if (Dependency.CMI.isEnabled()) {
                    int quantity = item.getAmount();
                    item.setAmount(1);
                    WorthItem worth = CMI.getInstance().getWorthManager().getWorth(item);
                    if (worth == null) continue;
                    Double sellPrice = worth.getSellPrice();
                    amount += sellPrice * (double)quantity;
                    item.setAmount(0);
                }
                if (!deleteUnsellable) continue;
                item.setAmount(0);
            }
            if (amount > 0.0) {
                SsomarDev.testMsg("SellContent activated > amount > " + (amount *= priceBoost), true);
                VaultAPI v = new VaultAPI();
                v.verifEconomy(p);
                v.addMoney(p, amount);
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SELL_CONTENT");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SELL_CONTENT priceBoost:1.0 deleteUnsellable:false";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

