/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.executableblocks.ExecutableBlocks;
import com.ssomar.executableblocks.api.ExecutableBlocksAPI;
import com.ssomar.executableblocks.executableblocks.ExecutableBlock;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.usedapi.MultiverseAPI;
import com.ssomar.score.utils.place.OverrideMode;
import com.ssomar.score.utils.safeplace.SafePlace;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SetExecutableBlock
extends BlockCommand {
    @Override
    public void run(Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        if (SCore.hasExecutableBlocks && Dependency.EXECUTABLE_BLOCKS.isEnabled()) {
            double z;
            double y;
            double x;
            Optional oOpt = ExecutableBlocksAPI.getExecutableBlocksManager().getExecutableBlock(args.get(0));
            if (!oOpt.isPresent()) {
                ExecutableBlocks.plugin.getLogger().severe("There is no ExecutableBlock associate with the ID: " + args.get(0) + " for the command SETEXECUTABLEBLOCK (object: " + aInfo.getName() + ")");
                return;
            }
            try {
                x = Double.parseDouble(args.get(1));
            }
            catch (Exception e) {
                SCore.plugin.getLogger().info("Tried to run the custom block command: SETEXECUTABLEBLOCK, but the x coordinate is not a number (x: " + args.get(1) + ")");
                return;
            }
            try {
                y = Double.parseDouble(args.get(2));
            }
            catch (Exception e) {
                SCore.plugin.getLogger().info("Tried to run the custom block command: SETEXECUTABLEBLOCK, but the y coordinate is not a number (y: " + args.get(2) + ")");
                return;
            }
            try {
                z = Double.parseDouble(args.get(3));
            }
            catch (Exception e) {
                SCore.plugin.getLogger().info("Tried to run the custom block command: SETEXECUTABLEBLOCK, but the z coordinate is not a number (z: " + args.get(3) + ")");
                return;
            }
            World world = null;
            String worldStr = args.get(4);
            if (worldStr.isEmpty()) {
                SCore.plugin.getLogger().info("Tried to run the custom block command: SETEXECUTABLEBLOCK, but the world is not specified (world: " + worldStr + ")");
                return;
            }
            world = SCore.hasMultiverse ? MultiverseAPI.getWorld(worldStr) : Bukkit.getWorld((String)worldStr);
            if (world == null) {
                SCore.plugin.getLogger().info("Tried to run the custom block command: SETEXECUTABLEBLOCK, but the world is not found (world: " + worldStr + ")");
                return;
            }
            boolean replace = false;
            try {
                replace = Boolean.parseBoolean(args.get(5));
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bypassProtection = false;
            try {
                bypassProtection = Boolean.parseBoolean(args.get(6));
            }
            catch (Exception exception) {
                // empty catch block
            }
            UUID ownerUUID = null;
            try {
                ownerUUID = UUID.fromString(args.get(args.size() - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            block = new Location(world, x, y, z).getBlock();
            Location loc = block.getLocation();
            if (!replace && !block.isEmpty()) {
                return;
            }
            OverrideMode overrideEBP = OverrideMode.KEEP_EXISTING;
            if (replace) {
                overrideEBP = OverrideMode.REMOVE_EXISTING;
            }
            UUID uuid = null;
            if (p != null) {
                uuid = p.getUniqueId();
            }
            if (uuid != null && !bypassProtection && !SafePlace.verifSafePlace(uuid, block)) {
                return;
            }
            ExecutableBlock eB = (ExecutableBlock)oOpt.get();
            eB.place(loc, true, overrideEBP, null, null, new InternalData().setOwnerUUID(ownerUUID));
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        Object error = "";
        String setEB = this.getTemplate();
        if (args.size() > 8) {
            error = "&cThere are &6too many args &cfor the command: &e" + setEB;
            return Optional.of(error);
        }
        if (args.size() < 5) {
            error = "&cThere is &6not enough args &cfor the command: &e" + setEB;
        } else {
            if (!SCore.hasExecutableBlocks || !Dependency.EXECUTABLE_BLOCKS.isEnabled()) {
                error = "You must have ExecutableBlock for the command" + setEB;
                return Optional.of(error);
            }
            if (!args.get(1).contains("%")) {
                try {
                    Double.valueOf(args.get(1));
                }
                catch (Exception e) {
                    error = "&cA SCommand contains an &6invalid coordinate&c: &e" + args.get(1) + " for command: " + setEB;
                    return Optional.of(error);
                }
            }
            if (!args.get(2).contains("%")) {
                try {
                    Double.valueOf(args.get(2));
                }
                catch (Exception e) {
                    error = "&cA SCommand contains an &6invalid coordinate&c: &e" + args.get(2) + " for command: " + setEB;
                    return Optional.of(error);
                }
            }
            if (!args.get(3).contains("%")) {
                try {
                    Double.valueOf(args.get(3));
                }
                catch (Exception e) {
                    error = "&cA SCommand contains an &6invalid coordinate&c: &e" + args.get(3) + " for command: " + setEB;
                    return Optional.of(error);
                }
            }
            String worldStr = args.get(4);
            if (!args.get(4).contains("%")) {
                if (worldStr.isEmpty()) {
                    error = "&cA SCommand contains an &6invalid world&c: &e" + args.get(4) + " for the command: " + setEB;
                    return Optional.of(error);
                }
                Optional<World> worldOptional = AllWorldManager.getWorld(worldStr);
                if (!worldOptional.isPresent()) {
                    error = "&cA SCommand contains an &6invalid world&c: &e" + args.get(4) + " for the command: " + setEB;
                    return Optional.of(error);
                }
            }
            if (args.size() > 5) {
                try {
                    Boolean.valueOf(args.get(5));
                }
                catch (Exception e) {
                    error = "&cA SCommand contains an &6invalid boolean&c: &e" + args.get(5) + " for the command: " + setEB;
                    return Optional.of(error);
                }
            }
        }
        return ((String)error).isEmpty() ? Optional.empty() : Optional.of(error);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SETEXECUTABLEBLOCK");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SETEXECUTABLEBLOCK {id} {x} {y} {z} {world} [replace true or false] [bypassProtection true or false] [ownerUUID]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

