/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.item;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.RunCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.item.ItemCommandManager;
import com.ssomar.score.commands.runnable.item.ItemMetaSCommand;
import com.ssomar.score.commands.runnable.item.ItemSCommand;
import com.ssomar.score.utils.DynamicMeta;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemRunCommand
extends RunCommand {
    private static final long serialVersionUID = 1L;
    private UUID launcherUUID;
    private ItemStack itemStack;
    private boolean silenceOutput;

    public ItemRunCommand(String brutCommand, int delay, ActionInfo aInfo) {
        super(brutCommand, delay, aInfo);
    }

    public ItemRunCommand(String brutCommand, long runTime, ActionInfo aInfo) {
        super(brutCommand, runTime, aInfo);
    }

    @Override
    public void pickupInfo() {
        ActionInfo aInfo = this.getaInfo();
        this.launcherUUID = aInfo.getLauncherUUID();
        this.itemStack = aInfo.getItemStack();
        this.silenceOutput = aInfo.isSilenceOutput();
    }

    @Override
    public void runGetManager() {
        this.runCommand(ItemCommandManager.getInstance());
    }

    @Override
    public void runCommand(SCommandToExec sCommandToExec) {
        @Nullable Player launcher = null;
        if (this.launcherUUID != null) {
            launcher = Bukkit.getPlayer((UUID)this.launcherUUID);
        }
        sCommandToExec.setActionInfo(this.getaInfo());
        if (sCommandToExec.getSCommand() instanceof ItemMetaSCommand) {
            ItemMetaSCommand pCommand = (ItemMetaSCommand)((Object)sCommandToExec.getSCommand());
            DynamicMeta dMeta = new DynamicMeta(this.itemStack.getItemMeta());
            pCommand.run(launcher, dMeta, sCommandToExec);
            this.itemStack.setItemMeta(dMeta.getMeta());
        } else if (sCommandToExec.getSCommand() instanceof ItemSCommand) {
            ItemSCommand pCommand = (ItemSCommand)((Object)sCommandToExec.getSCommand());
            pCommand.run(launcher, this.itemStack, sCommandToExec);
        }
        SsomarDev.testMsg("RUN COMMAND: >>>" + String.valueOf(sCommandToExec.getSCommand()), true);
    }

    @Override
    public void insideDelayedCommand() {
        this.runCommand(ItemCommandManager.getInstance());
    }

    @Override
    public void executeRunnable(Runnable runnable) {
        runnable.run();
    }

    @Generated
    public UUID getLauncherUUID() {
        return this.launcherUUID;
    }

    @Generated
    public void setLauncherUUID(UUID launcherUUID) {
        this.launcherUUID = launcherUUID;
    }

    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Generated
    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Generated
    public boolean isSilenceOutput() {
        return this.silenceOutput;
    }

    @Generated
    public void setSilenceOutput(boolean silenceOutput) {
        this.silenceOutput = silenceOutput;
    }
}

