/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.usedapi.WorldGuardAPI;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import com.ssomar.score.utils.numbers.NTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Damage
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        if (!(receiver instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingReceiver = (LivingEntity)receiver;
        if (receiver == null) {
            return;
        }
        double damage = Damage.getDamage(p, livingReceiver, args, aInfo);
        DamageSource damageSource = null;
        if (SCore.is1v20v5Plus()) {
            DamageType damageType = DamageType.INDIRECT_MAGIC;
            if (p != null) {
                damageType = DamageType.PLAYER_ATTACK;
            }
            try {
                damageType = (DamageType)Registry.DAMAGE_TYPE.get(NamespacedKey.minecraft((String)args.get(3).toLowerCase()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                damageSource = p != null ? DamageSource.builder((DamageType)damageType).withDirectEntity((Entity)p).withCausingEntity((Entity)p).build() : DamageSource.builder((DamageType)damageType).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Damage.damage(p, livingReceiver, damage, damageSource, aInfo);
    }

    public static void damage(Player p, LivingEntity receiver, double damage, Object damageSource, ActionInfo actionInfo) {
        if (damage > 0.0 && !receiver.isDead()) {
            int maximumNoDmg = receiver.getNoDamageTicks();
            receiver.setNoDamageTicks(0);
            boolean doDamage = true;
            if (SCore.hasWorldGuard && receiver instanceof Player) {
                doDamage = WorldGuardAPI.isInPvpZone((Player)receiver, receiver.getLocation());
            }
            if (receiver.isDead()) {
                return;
            }
            if (doDamage) {
                if (p != null) {
                    if (actionInfo.isActionRelatedToDamageEvent()) {
                        p.setMetadata("cancelDamageEvent", (MetadataValue)new FixedMetadataValue((Plugin)SCore.plugin, (Object)7772));
                    }
                    p.setMetadata("damageFromCustomCommand", (MetadataValue)new FixedMetadataValue((Plugin)SCore.plugin, (Object)7773));
                    if (SCore.is1v20v5Plus() && damageSource != null) {
                        receiver.damage(damage, (DamageSource)damageSource);
                    } else {
                        receiver.damage(damage, (Entity)p);
                    }
                } else if (SCore.is1v20v5Plus() && damageSource != null) {
                    receiver.damage(damage, (DamageSource)damageSource);
                } else {
                    receiver.damage(damage);
                }
            }
            if (!receiver.isDead()) {
                receiver.setNoDamageTicks(maximumNoDmg);
            }
        }
    }

    public static double getDamage(Player launcher, LivingEntity receiver, List<String> args, ActionInfo actionInfo) {
        double amount;
        Object damage = args.get(0);
        boolean potionAmplification = false;
        if (args.size() >= 2) {
            potionAmplification = Boolean.valueOf(args.get(1));
        }
        boolean attributeAmplification = false;
        if (args.size() >= 3) {
            attributeAmplification = Boolean.valueOf(args.get(2));
        }
        if (((String)damage).contains("%")) {
            String[] decomp = ((String)damage).split("%");
            damage = decomp[0];
            if (((String)(damage = ((String)damage).trim())).length() == 1) {
                damage = "0" + (String)damage;
            }
            double percentage = ((String)damage).equals("100") ? 1.0 : Double.parseDouble("0." + (String)damage);
            amount = receiver.getMaxHealth() * percentage;
            amount = NTools.reduceDouble(amount, 2);
        } else {
            amount = Double.parseDouble((String)damage);
        }
        if (launcher != null) {
            PotionEffectType incDamage;
            PotionEffect pE;
            if (potionAmplification && (pE = launcher.getPotionEffect(incDamage = SCore.is1v20v5Plus() ? PotionEffectType.STRENGTH : PotionEffectType.getByName((String)"INCREASE_DAMAGE"))) != null) {
                amount += (double)((pE.getAmplifier() + 1) * 3);
            }
            if (attributeAmplification) {
                Attribute att = null;
                att = SCore.is1v21v2Plus() ? Attribute.ATTACK_DAMAGE : AttributeUtils.getAttribute("GENERIC_ATTACK_DAMAGE");
                AttributeInstance aI = launcher.getAttribute(att);
                double bonusAmount = 0.0;
                if (aI != null) {
                    for (AttributeModifier aM : aI.getModifiers()) {
                        if (!aM.getOperation().equals((Object)AttributeModifier.Operation.MULTIPLY_SCALAR_1)) continue;
                        bonusAmount += amount * aM.getAmount();
                    }
                }
                amount += bonusAmount;
            }
        }
        return amount;
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Damage.staticVerif(args, isFinalVerification, this.getTemplate());
    }

    public static Optional<String> staticVerif(List<String> args, boolean isFinalVerification, String template) {
        String value;
        ArgumentChecker ac2;
        if (args.size() < 1) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + template);
        }
        ArgumentChecker ac = Damage.checkDouble(args.get(0), isFinalVerification, template, true);
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        if (args.size() >= 2 && !(ac2 = Damage.checkBoolean(value = args.get(1), isFinalVerification, template)).isValid()) {
            return Optional.of(ac2.getError());
        }
        if (args.size() >= 3 && !(ac2 = Damage.checkBoolean(value = args.get(2), isFinalVerification, template)).isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DAMAGE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DAMAGE {number} [amplified If Strength Effect, true or false] [amplified with attack attribute, true or false] [damageType]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

