/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DamageResistance
extends MixedCommand {
    private static final Boolean DEBUG = false;
    private static DamageResistance instance;
    private final Map<UUID, List<Double>> activeResistances = new HashMap<UUID, List<Double>>();

    public static DamageResistance getInstance() {
        if (instance == null) {
            instance = new DamageResistance();
        }
        return instance;
    }

    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final double reduction = Double.valueOf(args.get(0));
        int time = Double.valueOf(args.get(1)).intValue();
        final UUID uuid = receiver.getUniqueId();
        if (this.activeResistances.containsKey(uuid)) {
            this.activeResistances.get(uuid).add(reduction);
        } else {
            this.activeResistances.put(uuid, new ArrayList<Double>(Collections.singletonList(reduction)));
        }
        Runnable runnable3 = new Runnable(){
            final /* synthetic */ DamageResistance this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.activeResistances.containsKey(uuid)) {
                    if (this.this$0.activeResistances.get(uuid).size() > 1) {
                        this.this$0.activeResistances.get(uuid).remove(reduction);
                    } else {
                        this.this$0.activeResistances.remove(uuid);
                    }
                }
            }
        };
        SCore.schedulerHook.runTask(runnable3, time);
    }

    public double getNewDamage(UUID uuid, double damage) {
        if (DamageResistance.getInstance().getActiveResistances().containsKey(uuid)) {
            if (DEBUG.booleanValue()) {
                SsomarDev.testMsg("DamageResistanceEvent base: " + damage, DEBUG);
            }
            double resistance = 0.0;
            for (double d : DamageResistance.getInstance().getActiveResistances().get(uuid)) {
                resistance += d;
            }
            double averagePercent = resistance / 100.0;
            damage += damage * averagePercent;
            if (DEBUG.booleanValue()) {
                SsomarDev.testMsg("DamageResistanceEvent modified " + damage, DEBUG);
            }
        }
        return damage;
    }

    public Optional<String> onRequestPlaceholder(@NotNull OfflinePlayer player, String params) {
        if (params.startsWith("cmd-damage-resistance")) {
            return Optional.of(String.valueOf(this.getNewDamage(player.getUniqueId(), 1.0)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 2) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = DamageResistance.checkDouble(args.get(0), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        ArgumentChecker ac2 = DamageResistance.checkDouble(args.get(1), isFinalVerification, this.getTemplate());
        if (!ac2.isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DAMAGE_RESISTANCE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DAMAGE_RESISTANCE {modification in percentage example 100} {timeinticks}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    @Generated
    public Map<UUID, List<Double>> getActiveResistances() {
        return this.activeResistances;
    }
}

