/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.commands.runnable.mixed_player_entity.commands.TeleportOnCursorManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TeleportOnCursor
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        if (!(receiver instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingReceiver = (LivingEntity)receiver;
        int amount = 200;
        boolean acceptAir = false;
        if (args.size() >= 1) {
            amount = Double.valueOf(args.get(0)).intValue();
        }
        if (args.size() >= 2) {
            acceptAir = Boolean.parseBoolean(args.get(1));
        }
        try {
            boolean validTp;
            Location eyeLoc = livingReceiver.getEyeLocation();
            Vector eyeVec = eyeLoc.getDirection();
            Vector checkVec = eyeVec.clone().multiply(2);
            Location checkLoc = eyeLoc.clone().add(checkVec);
            Block faceBlock = checkLoc.add(eyeVec.multiply(0.5)).getBlock();
            if (!this.isAirBlock(faceBlock)) {
                return;
            }
            boolean invalid = false;
            for (int cpt = 2; cpt < amount && this.isAirBlock((checkLoc = eyeLoc.clone().add(eyeVec.clone().multiply(cpt))).getBlock()); ++cpt) {
                if (this.isAirBlock(checkLoc.clone().add(0.0, 1.0, 0.0).getBlock())) continue;
                invalid = true;
                break;
            }
            if (invalid) {
                return;
            }
            Material mat = checkLoc.getBlock().getType();
            boolean bl = validTp = acceptAir && this.isAirBlock(checkLoc.getBlock()) || !this.isAirBlock(checkLoc.getBlock()) && mat.isBlock() && !mat.equals((Object)Material.LAVA);
            if (validTp && this.isAirBlock(checkLoc.clone().add(0.0, 1.0, 0.0).getBlock()) && this.isAirBlock(checkLoc.clone().add(0.0, 2.0, 0.0).getBlock()) && TeleportOnCursorManager.getInstance().canTp(receiver.getUniqueId())) {
                if (SCore.isFolia()) {
                    receiver.teleportAsync(checkLoc.add(0.0, 1.0, 0.0));
                } else {
                    receiver.teleport(checkLoc.add(0.0, 1.0, 0.0));
                }
                SsomarDev.testMsg("TeleportOnCursor command executed on entity: " + String.valueOf(receiver.getType()) + " at location: " + String.valueOf(checkLoc), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAirBlock(Block block) {
        Material mat = block.getType();
        return SCore.is1v16Plus() && mat.isAir() || !SCore.is1v16Plus() && mat.equals((Object)Material.AIR);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        ArgumentChecker ac2;
        if (args.size() >= 1 && !(ac2 = TeleportOnCursor.checkInteger(args.get(0), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac2.getError());
        }
        if (args.size() >= 2 && !(ac2 = TeleportOnCursor.checkBoolean(args.get(1), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("TELEPORTONCURSOR");
        return names;
    }

    @Override
    public String getTemplate() {
        return "TELEPORTONCURSOR [maxRange} [acceptAir true or false]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

