/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Player;

public class Bossbar
extends PlayerCommand {
    private static Bossbar instance;
    Map<Player, Map<BossBar, ScheduledTask>> cache;

    public Bossbar() {
        instance = this;
        this.cache = new HashMap<Player, Map<BossBar, ScheduledTask>>();
        CommandSetting time = new CommandSetting("time", 0, Integer.class, (Object)200);
        CommandSetting color = new CommandSetting("color", 1, BarColor.class, (Object)BarColor.BLUE);
        CommandSetting text = new CommandSetting("text", 2, String.class, (Object)"Hello_world");
        CommandSetting count = new CommandSetting("count", -1, Integer.class, (Object)0);
        CommandSetting countTicks = new CommandSetting("countTicks", -1, Boolean.class, (Object)false);
        CommandSetting countOrder = new CommandSetting("countOrder", -1, String.class, (Object)"descending");
        CommandSetting hideCount = new CommandSetting("hideCount", -1, Boolean.class, (Object)false);
        CommandSetting overrideMode = new CommandSetting("overrideMode", -1, String.class, (Object)"NO_OVERRIDE");
        text.setAcceptUnderScoreForLongText(true);
        List<CommandSetting> settings = this.getSettings();
        settings.add(time);
        settings.add(color);
        settings.add(text);
        settings.add(count);
        settings.add(countTicks);
        settings.add(countOrder);
        settings.add(hideCount);
        settings.add(overrideMode);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        BarColor color = (BarColor)sCommandToExec.getSettingValue("color");
        String text = (String)sCommandToExec.getSettingValue("text");
        Integer time = (Integer)sCommandToExec.getSettingValue("time");
        final Integer count = (Integer)sCommandToExec.getSettingValue("count");
        Boolean countTicks = (Boolean)sCommandToExec.getSettingValue("countTicks");
        String countOrder = ((String)sCommandToExec.getSettingValue("countOrder")).toLowerCase();
        final boolean isAscending = countOrder.equalsIgnoreCase("ascending");
        boolean hideCount = (Boolean)sCommandToExec.getSettingValue("hideCount");
        String overrideMode = (String)sCommandToExec.getSettingValue("overrideMode");
        List<String> args = sCommandToExec.getOtherArgs();
        StringBuilder message = new StringBuilder(text);
        message.append(" ");
        for (String s : args) {
            message.append(s).append(" ");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        String coloredMessage = StringConverter.coloredString(message.toString());
        if (overrideMode.equalsIgnoreCase("OVERRIDE_ALL")) {
            tasks = this.cache.get(receiver);
            if (tasks != null) {
                for (Map.Entry<BossBar, ScheduledTask> entry : tasks.entrySet()) {
                    this.removeBossBar(entry.getKey(), receiver);
                }
            }
        } else if (overrideMode.equalsIgnoreCase("OVERRIDE_SAME_TEXT")) {
            SsomarDev.testMsg("Override mode: " + overrideMode, true);
            tasks = this.cache.get(receiver);
            if (tasks != null) {
                for (Map.Entry<BossBar, ScheduledTask> entry : tasks.entrySet()) {
                    BossBar bossBar = entry.getKey();
                    SsomarDev.testMsg("Checking boss bar with same text: " + bossBar.getTitle(), true);
                    SsomarDev.testMsg("Boss bar with same text: " + bossBar.getTitle() + " vs " + coloredMessage, true);
                    if (!StringConverter.decoloredString(bossBar.getTitle()).contains(StringConverter.decoloredString(coloredMessage))) continue;
                    SsomarDev.testMsg("Removing boss bar with same text: " + bossBar.getTitle(), true);
                    this.removeBossBar(entry.getKey(), receiver);
                }
            }
        }
        if (!coloredMessage.isEmpty()) {
            KeyedBossBar bossBar = Bukkit.createBossBar((NamespacedKey)NamespacedKey.randomKey(), (String)coloredMessage, (BarColor)color, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bossBar.addPlayer(receiver);
            if (this.cache.containsKey(receiver)) {
                this.cache.get(receiver).put((BossBar)bossBar, null);
            } else {
                HashMap<KeyedBossBar, Object> map = new HashMap<KeyedBossBar, Object>();
                map.put(bossBar, null);
                this.cache.put(receiver, map);
            }
            String finalMessage = message.toString();
            if (count > 0) {
                AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
                Runnable runnable = new Runnable(){
                    int counter;
                    final /* synthetic */ BossBar val$bossBar;
                    final /* synthetic */ Player val$receiver;
                    final /* synthetic */ Boolean val$countTicks;
                    final /* synthetic */ boolean val$hideCount;
                    final /* synthetic */ String val$finalMessage;
                    final /* synthetic */ Bossbar this$0;
                    {
                        this.val$bossBar = bossBar;
                        this.val$receiver = player;
                        this.val$countTicks = bl2;
                        this.val$hideCount = bl3;
                        this.val$finalMessage = string;
                        this.this$0 = this$0;
                        this.counter = isAscending ? 0 : count;
                    }

                    @Override
                    public void run() {
                        if (isAscending) {
                            if (this.counter >= count) {
                                this.this$0.removeBossBar(this.val$bossBar, this.val$receiver);
                                return;
                            }
                            ++this.counter;
                        } else {
                            if (this.counter <= 0) {
                                this.this$0.removeBossBar(this.val$bossBar, this.val$receiver);
                                return;
                            }
                            --this.counter;
                        }
                        Object countText = String.valueOf(this.counter);
                        if (!this.val$countTicks.booleanValue()) {
                            countText = (String)countText + "s";
                        }
                        this.val$bossBar.setProgress((double)this.counter / (double)count.intValue());
                        if (this.val$hideCount) {
                            this.val$bossBar.setTitle(StringConverter.coloredString(this.val$finalMessage));
                        } else {
                            this.val$bossBar.setTitle(StringConverter.coloredString(this.val$finalMessage + " " + (String)countText));
                        }
                    }
                };
                task.set(SCore.schedulerHook.runRepeatingTask(runnable, 0L, countTicks != false ? 1L : 20L));
                if (this.cache.containsKey(receiver)) {
                    this.cache.get(receiver).put((BossBar)bossBar, (ScheduledTask)task.get());
                } else {
                    HashMap<KeyedBossBar, ScheduledTask> map = new HashMap<KeyedBossBar, ScheduledTask>();
                    map.put(bossBar, (ScheduledTask)task.get());
                    this.cache.put(receiver, map);
                }
            } else {
                Runnable runnable = new Runnable(){
                    final /* synthetic */ BossBar val$bossBar;
                    final /* synthetic */ Player val$receiver;
                    final /* synthetic */ Bossbar this$0;
                    {
                        this.val$bossBar = bossBar;
                        this.val$receiver = player;
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.removeBossBar(this.val$bossBar, this.val$receiver);
                    }
                };
                SCore.schedulerHook.runTask(runnable, time.intValue());
            }
        }
    }

    public void removeBossBar(BossBar bossBar, Player p) {
        Map<BossBar, ScheduledTask> tasks;
        bossBar.removeAll();
        if (bossBar instanceof KeyedBossBar) {
            NamespacedKey key = ((KeyedBossBar)bossBar).getKey();
            Bukkit.getServer().removeBossBar(key);
        }
        if ((tasks = this.cache.get(p)) == null) {
            return;
        }
        ScheduledTask task = tasks.get(bossBar);
        if (task == null) {
            return;
        }
        task.cancel();
        tasks.remove(bossBar);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("BOSSBAR");
        return names;
    }

    @Override
    public String getTemplate() {
        return "BOSSBAR time:200 color:BLUE text:Hello_world count:0 countTicks:false countOrder:descending";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    public static Bossbar getInstance() {
        if (instance == null) {
            instance = new Bossbar();
        }
        return instance;
    }

    public void clearTasks(Player p) {
        Map<BossBar, ScheduledTask> tasks = this.cache.get(p);
        if (tasks != null) {
            for (Map.Entry<BossBar, ScheduledTask> entry : tasks.entrySet()) {
                this.removeBossBar(entry.getKey(), p);
            }
            tasks.clear();
        }
    }

    public void clearTasks() {
        for (Player p : this.cache.keySet()) {
            this.clearTasks(p);
        }
    }
}

