/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.RunConsoleCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.safeplace.SafePlace;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SetBlockPos
extends PlayerCommand {
    public SetBlockPos() {
        CommandSetting x = new CommandSetting("x", 0, Double.class, (Object)0.0);
        CommandSetting y = new CommandSetting("y", 1, Double.class, (Object)0.0);
        CommandSetting z = new CommandSetting("z", 2, Double.class, (Object)0.0);
        CommandSetting material = new CommandSetting("material", 3, Material.class, (Object)Material.STONE);
        CommandSetting bypassProtection = new CommandSetting("bypassProtection", 4, Boolean.class, (Object)false);
        CommandSetting replace = new CommandSetting("replace", -1, Boolean.class, (Object)true);
        List<CommandSetting> settings = this.getSettings();
        settings.add(x);
        settings.add(y);
        settings.add(z);
        settings.add(material);
        settings.add(bypassProtection);
        settings.add(replace);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        double x = (Double)sCommandToExec.getSettingValue("x");
        double y = (Double)sCommandToExec.getSettingValue("y");
        double z = (Double)sCommandToExec.getSettingValue("z");
        Material material = (Material)sCommandToExec.getSettingValue("material");
        boolean bypassProtection = (Boolean)sCommandToExec.getSettingValue("bypassProtection");
        boolean replace = (Boolean)sCommandToExec.getSettingValue("replace");
        Location loc = receiver.getLocation();
        Location blockLoc = new Location(loc.getWorld(), x, y, z);
        Block block = blockLoc.getBlock();
        UUID uuid = receiver.getUniqueId();
        if (!(block = block.getWorld().getBlockAt(blockLoc)).isEmpty() && !replace) {
            return;
        }
        if (material != null) {
            SafePlace.placeBlockWithEvent(block, material, Optional.empty(), uuid, false, !bypassProtection);
        } else {
            World w = loc.getWorld();
            List entities = w.getEntities();
            if (!entities.isEmpty()) {
                if (!bypassProtection && !SafePlace.verifSafePlace(uuid, block)) {
                    return;
                }
                RunConsoleCommand.runConsoleCommand("execute at " + String.valueOf(((Entity)entities.get(0)).getUniqueId()) + " run setblock " + block.getX() + " " + block.getY() + " " + block.getZ() + " " + material.toString().toLowerCase() + " replace", sCommandToExec.getActionInfo().isSilenceOutput());
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_BLOCK_POS");
        names.add("SETBLOCKPOS");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_BLOCK_POS x:0 y:0 z:0 material:STONE bypassProtection:false replace:true";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

