/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.CommandsExecutor;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.commands.runnable.player.PlayerRunCommandsBuilder;
import com.ssomar.score.features.custom.conditions.placeholders.placeholder.PlaceholderConditionFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.ComparatorFeature;
import com.ssomar.score.features.types.PlaceholderConditionTypeFeature;
import com.ssomar.score.utils.emums.Comparator;
import com.ssomar.score.utils.emums.PlaceholdersCdtType;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class While
extends PlayerCommand {
    private static final boolean DEBUG = false;
    private static While instance;
    private final Map<UUID, List<ScheduledTask>> whileTasks = new HashMap<UUID, List<ScheduledTask>>();

    @Override
    public void run(Player p, final Player receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final ActionInfo aInfo = sCommandToExec.getActionInfo();
        SsomarDev.testMsg("WHILE STARTED", false);
        final PlaceholderConditionFeature conditionFeature = PlaceholderConditionFeature.buildNull();
        conditionFeature.setType(PlaceholderConditionTypeFeature.buildNull(PlaceholdersCdtType.PLAYER_PLAYER));
        String condition = args.get(0);
        int delay = (int)Double.parseDouble(aInfo.getSp().replacePlaceholder(args.get(1)));
        Comparator comparator = null;
        for (Comparator c : Comparator.values()) {
            if (!condition.contains("%" + c.getSymbol())) continue;
            conditionFeature.setComparator(ComparatorFeature.buildNull(c));
            comparator = c;
            break;
        }
        if (comparator == null) {
            return;
        }
        String[] parts = condition.split("%" + comparator.getSymbol());
        conditionFeature.setPart1(ColoredStringFeature.buildNull(parts[0] + "%"));
        conditionFeature.setPart2(ColoredStringFeature.buildNull(parts[1]));
        final StringPlaceholder sp = new StringPlaceholder();
        sp.setPlayerPlcHldr(receiver.getUniqueId());
        StringBuilder cmdsDef = new StringBuilder();
        for (int i = 2; i < args.size(); ++i) {
            String cmd = args.get(i);
            cmdsDef.append(cmd).append(" ");
        }
        cmdsDef = new StringBuilder(cmdsDef.toString().trim());
        SsomarDev.testMsg("WHILE CMD DEF: " + String.valueOf(cmdsDef), false);
        String[] cmdsArray = cmdsDef.toString().split("<\\+>");
        final ArrayList<String> cmds = new ArrayList<String>();
        for (String cmd : cmdsArray) {
            cmds.add(cmd);
            SsomarDev.testMsg("WHILE CMD: " + cmd, false);
        }
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final /* synthetic */ While this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                sp.reloadAllPlaceholders();
                if (conditionFeature.verify(receiver, null, sp) && receiver.isOnline()) {
                    PlayerRunCommandsBuilder builder = new PlayerRunCommandsBuilder(cmds, aInfo);
                    CommandsExecutor.runCommands(builder);
                } else {
                    SsomarDev.testMsg("WHILE STOPPED", false);
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, delay));
        List<ScheduledTask> tasks = this.whileTasks.get(receiver.getUniqueId());
        if (tasks == null) {
            tasks = new ArrayList<ScheduledTask>();
        }
        tasks.add((ScheduledTask)task.get());
        this.whileTasks.put(receiver.getUniqueId(), tasks);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 3) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = While.checkDouble(args.get(1), false, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("WHILE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "WHILE {condition_without_spaces} {delay_in_ticks} {command1} <+> {command2} <+> ...";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    public void removeWhile(UUID uuid) {
        List<ScheduledTask> tasks = this.whileTasks.get(uuid);
        if (tasks != null) {
            for (ScheduledTask task : tasks) {
                task.cancel();
            }
        }
        this.whileTasks.remove(uuid);
    }

    public static While getInstance() {
        if (instance == null) {
            instance = new While();
        }
        return instance;
    }
}

