/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands.sudoop;

import com.ssomar.score.data.Database;
import com.ssomar.score.data.SecurityOPQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;

public class SUDOOPManager {
    private static SUDOOPManager instance;
    private HashMap<Player, List<String>> commandsAsOP = new HashMap();
    private List<UUID> playersThatMustBeDeOP = SecurityOPQuery.loadUsersOp(Database.getInstance().connect());

    public static void performCommand(Player player, String command) {
        player.chat(command);
    }

    public static SUDOOPManager getInstance() {
        if (instance == null) {
            instance = new SUDOOPManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOPCommand(Player player, String cmd) {
        String command = this.verifyCommand(cmd);
        if (player.isOp()) {
            SUDOOPManager.performCommand(player, command);
        } else {
            try {
                if (this.commandsAsOP.containsKey(player)) {
                    this.commandsAsOP.get(player).add(command);
                } else {
                    ArrayList<String> cList = new ArrayList<String>();
                    cList.add(command);
                    this.commandsAsOP.put(player, cList);
                }
                if (SecurityOPQuery.insertPlayerOP(Database.getInstance().connect(), Collections.singletonList(player))) {
                    player.setOp(true);
                    SUDOOPManager.performCommand(player, command);
                }
            }
            finally {
                player.setOp(false);
                SecurityOPQuery.deletePlayerOP(Database.getInstance().connect(), player, true);
                if (this.commandsAsOP.get(player).size() == 1) {
                    this.commandsAsOP.remove(player);
                } else {
                    this.commandsAsOP.get(player).remove(command);
                }
            }
        }
    }

    public String verifyCommand(String cmd) {
        Object command = cmd.trim();
        if (((String)command).charAt(0) != '/') {
            command = "/" + (String)command;
        }
        return command;
    }

    @Generated
    public HashMap<Player, List<String>> getCommandsAsOP() {
        return this.commandsAsOP;
    }

    @Generated
    public List<UUID> getPlayersThatMustBeDeOP() {
        return this.playersThatMustBeDeOP;
    }

    @Generated
    public void setCommandsAsOP(HashMap<Player, List<String>> commandsAsOP) {
        this.commandsAsOP = commandsAsOP;
    }

    @Generated
    public void setPlayersThatMustBeDeOP(List<UUID> playersThatMustBeDeOP) {
        this.playersThatMustBeDeOP = playersThatMustBeDeOP;
    }
}

