/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.util;

import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.util.commands.Delay;
import com.ssomar.score.commands.runnable.util.commands.DelayTick;
import com.ssomar.score.commands.runnable.util.commands.Nothing;
import com.ssomar.score.commands.runnable.util.commands.RandomEnd;
import com.ssomar.score.commands.runnable.util.commands.RandomRun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;

public class UtilCommandsManager {
    private static UtilCommandsManager instance;
    private List<SCommand> commands;

    public UtilCommandsManager() {
        ArrayList<SCommand> commands = new ArrayList<SCommand>();
        commands.add(new Delay());
        commands.add(new DelayTick());
        commands.add(new Nothing());
        commands.add(new RandomRun());
        commands.add(new RandomEnd());
        this.commands = commands;
    }

    public static UtilCommandsManager getInstance() {
        if (instance == null) {
            instance = new UtilCommandsManager();
        }
        return instance;
    }

    public List<SCommand> getCommands() {
        return this.commands;
    }

    public void setCommands(List<SCommand> commands) {
        this.commands = commands;
    }

    public Map<String, String> getCommandsDisplay() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (SCommand c : this.commands) {
            ChatColor color;
            ChatColor extra = c.getExtraColor();
            if (extra == null) {
                extra = ChatColor.GOLD;
            }
            if ((color = c.getColor()) == null) {
                color = ChatColor.YELLOW;
            }
            result.put(String.valueOf(extra) + "[" + String.valueOf(color) + "&l" + c.getNames().get(0) + String.valueOf(extra) + "]", c.getTemplate());
        }
        return result;
    }
}

