/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.score;

import com.ssomar.executableblocks.executableblocks.activators.ActivatorEBFeature;
import com.ssomar.executableevents.executableevents.activators.ActivatorEEFeature;
import com.ssomar.executableitems.executableitems.activators.ActivatorEIFeature;
import com.ssomar.particles.commands.Parameter;
import com.ssomar.particles.commands.Shape;
import com.ssomar.particles.commands.ShapesExamples;
import com.ssomar.particles.commands.ShapesManager;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsExecutor;
import com.ssomar.score.commands.runnable.block.BlockCommandManager;
import com.ssomar.score.commands.runnable.block.BlockRunCommandsBuilder;
import com.ssomar.score.commands.runnable.entity.EntityCommandManager;
import com.ssomar.score.commands.runnable.entity.EntityRunCommandsBuilder;
import com.ssomar.score.commands.runnable.player.PlayerCommandManager;
import com.ssomar.score.commands.runnable.player.PlayerRunCommandsBuilder;
import com.ssomar.score.commands.score.clear.ClearCommand;
import com.ssomar.score.commands.score.clear.ClearType;
import com.ssomar.score.configs.messages.Message;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.events.loop.LoopManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.cooldowns.CooldownsManager;
import com.ssomar.score.features.custom.loop.LoopFeatures;
import com.ssomar.score.hardness.hardness.Hardness;
import com.ssomar.score.hardness.hardness.HardnessesEditor;
import com.ssomar.score.hardness.hardness.manager.HardnessesManager;
import com.ssomar.score.projectiles.SProjectile;
import com.ssomar.score.projectiles.SProjectilesEditor;
import com.ssomar.score.projectiles.manager.SProjectilesManager;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.emums.VariableType;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.messages.CenteredMessage;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import com.ssomar.score.utils.strings.StringJoiner;
import com.ssomar.score.variables.Variable;
import com.ssomar.score.variables.VariableForEnum;
import com.ssomar.score.variables.VariablesEditor;
import com.ssomar.score.variables.manager.VariablesManager;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class CommandsClass
implements CommandExecutor,
TabExecutor {
    @NotNull
    private final SendMessage sm = new SendMessage();
    @NotNull
    private final SCore main;
    private final String[] commands = new String[]{"clear", "cooldowns", "hardnesses", "hardnesses-create", "hardnesses-delete", "inspect-loop", "particles", "particles-info", "projectiles", "projectiles-create", "projectiles-delete", "reload", "run-entity-command", "run-block-command", "run-player-command", "variables", "variables-create", "variables-define", "variables-delete", "webhook", "no-translated"};

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length > 0) {
            String commandName = args[0].toLowerCase();
            if (Arrays.asList(this.commands).contains(commandName)) {
                this.runCommand(sender, commandName, args);
            } else {
                sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid argument! Usage: /score &8[ &7" + StringJoiner.join(this.commands, " &c| &7") + " &8]"));
            }
        } else {
            sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid argument! Usage: /score &8[ &7" + StringJoiner.join(this.commands, " &c| &7") + " &8]"));
        }
        return true;
    }

    public void runCommand(CommandSender sender, String command, String[] fullArgs) {
        String[] args;
        if (fullArgs.length > 1) {
            args = new String[fullArgs.length - 1];
            for (int i = 0; i < fullArgs.length; ++i) {
                if (i == 0) continue;
                args[i - 1] = fullArgs[i];
            }
        } else {
            args = new String[]{};
        }
        Player player = null;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("score.cmd." + command) && !player.hasPermission("score.cmds") && !player.hasPermission("score.*")) {
            player.sendMessage(StringConverter.coloredString("&4[SCore] &cYou don't have the permission to execute this command: &6score.cmd." + command + "&c."));
            return;
        }
        switch (command.toLowerCase()) {
            case "no-translated": {
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cNo translated text sent in your console. &7(You can send it to Ssomar in the suggestions channel on the discord).");
                Utils.sendConsoleFlatMsg(SCore.plugin, FeatureSettingsSCore.getAllNonTranslated());
                break;
            }
            case "clear": {
                ClearCommand.clearCmd(SCore.plugin, sender, args);
                break;
            }
            case "cooldowns": {
                if (args.length >= 1) {
                    switch (args[0]) {
                        case "clear": {
                            if (args.length < 2) {
                                sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid argument! Usage: /score cooldowns clear &7cooldownId"));
                                return;
                            }
                            String cooldownId = args[1];
                            UUID uuid = null;
                            if (args.length >= 3) {
                                try {
                                    uuid = UUID.fromString(args[2]);
                                }
                                catch (Exception e) {
                                    try {
                                        uuid = Bukkit.getPlayer((String)args[2]).getUniqueId();
                                    }
                                    catch (Exception e2) {
                                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid UUID or player name : &6" + args[2]));
                                    }
                                }
                            }
                            CooldownsManager.getInstance().clearCooldown(cooldownId, uuid);
                            sender.sendMessage(StringConverter.coloredString("&2[SCore] &aCooldown &e" + cooldownId + " &acleared!"));
                        }
                    }
                    break;
                }
                CooldownsManager.getInstance().printInfo();
                sender.sendMessage(StringConverter.coloredString("&2[SCore] &aCooldowns printed in console!"));
                break;
            }
            case "variables": {
                if (args.length >= 1) {
                    if (args[0].equalsIgnoreCase("info")) {
                        if (args.length < 2) break;
                        Optional<Variable> var2 = VariablesManager.getInstance().getVariable(args[1]);
                        if (var2.isPresent()) {
                            SendMessage.sendMessageFinal(sender, var2.get().getValuesStr(), false);
                            break;
                        }
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cVariable (&6" + args[1] + ") &cnot found!"));
                        break;
                    }
                    if (args[0].equalsIgnoreCase("list")) {
                        sender.sendMessage(VariablesManager.getInstance().getVariableIdsListStr());
                        break;
                    }
                    if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("modification") || args[0].equalsIgnoreCase("list-add") || args[0].equalsIgnoreCase("list-remove") || args[0].equalsIgnoreCase("clear")) {
                        Optional<Variable> variableOpt;
                        int argIndex = 0;
                        String modifType = args[argIndex];
                        String forType = args[++argIndex];
                        String varName = args[++argIndex];
                        ++argIndex;
                        String value2 = "";
                        if (!args[0].equalsIgnoreCase("list-remove") && !args[0].equalsIgnoreCase("clear")) {
                            if (args.length <= argIndex) {
                                sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid value!"));
                                return;
                            }
                            value2 = args[argIndex];
                            ++argIndex;
                        }
                        Optional<Object> optPlayer = Optional.empty();
                        String playerStr = "";
                        if (args.length >= argIndex + 1 && forType.equalsIgnoreCase("player")) {
                            try {
                                playerStr = args[argIndex];
                                optPlayer = Optional.of(Bukkit.getOfflinePlayer((String)args[argIndex]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Optional<Integer> indexOpt = Optional.empty();
                        if (args.length >= argIndex + 1 && (modifType.equalsIgnoreCase("list-add") || modifType.equalsIgnoreCase("list-remove"))) {
                            for (int i = argIndex; i < args.length; ++i) {
                                if (!args[i].contains("index:")) continue;
                                try {
                                    indexOpt = Optional.of(Integer.parseInt(args[i].replace("index:", "")));
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid index!"));
                                }
                            }
                        }
                        Optional<String> valueOpt = Optional.empty();
                        if (args.length >= argIndex + 1 && modifType.equalsIgnoreCase("list-remove")) {
                            for (int i = argIndex; i < args.length; ++i) {
                                if (!args[i].contains("value:")) continue;
                                try {
                                    valueOpt = Optional.of(args[i].replace("value:", ""));
                                    continue;
                                }
                                catch (Exception e) {
                                    sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid value!"));
                                }
                            }
                        }
                        if ((variableOpt = VariablesManager.getInstance().getVariable(varName)).isPresent()) {
                            String variableValueSetMsg = MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.VARIABLE_VALUE_SET).replace("%player%", optPlayer.map(OfflinePlayer::getName).orElse("null")).replace("%variable_name%", variableOpt.get().getId()).replace("%variable_value%", value2);
                            if (modifType.equalsIgnoreCase("set")) {
                                Optional<String> errorOpt = variableOpt.get().setValue(optPlayer, value2);
                                if (errorOpt.isPresent()) {
                                    sender.sendMessage(errorOpt.get());
                                } else {
                                    SendMessage.sendMessageNoPlch(sender, variableValueSetMsg);
                                }
                            } else if (modifType.equalsIgnoreCase("modification")) {
                                Optional<String> errorOpt = variableOpt.get().modifValue(optPlayer, value2);
                                if (errorOpt.isPresent()) {
                                    sender.sendMessage(errorOpt.get());
                                } else {
                                    SendMessage.sendMessageNoPlch(sender, variableValueSetMsg);
                                }
                            } else if (modifType.equalsIgnoreCase("list-add")) {
                                Optional<String> errorOpt = variableOpt.get().addValue(optPlayer, value2, indexOpt);
                                if (errorOpt.isPresent()) {
                                    sender.sendMessage(errorOpt.get());
                                } else {
                                    SendMessage.sendMessageNoPlch(sender, variableValueSetMsg);
                                }
                            } else if (modifType.equalsIgnoreCase("list-remove")) {
                                Optional<String> errorOpt = variableOpt.get().removeValue(optPlayer, indexOpt, valueOpt);
                                if (errorOpt.isPresent()) {
                                    sender.sendMessage(errorOpt.get());
                                } else {
                                    SendMessage.sendMessageNoPlch(sender, variableValueSetMsg);
                                }
                            } else if (modifType.equalsIgnoreCase("clear")) {
                                Optional<String> errorOpt = playerStr.equalsIgnoreCase("all") ? variableOpt.get().clearAllValues() : variableOpt.get().clearValue(optPlayer);
                                if (errorOpt.isPresent()) {
                                    sender.sendMessage(errorOpt.get());
                                } else {
                                    SendMessage.sendMessageNoPlch(sender, variableValueSetMsg);
                                }
                            }
                            VariablesManager.getInstance().updateLoadedMySQL(variableOpt.get().getId(), VariablesManager.MODE.EXPORT);
                            break;
                        }
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cVariable (&6" + args[1] + ") &cnot found!"));
                        break;
                    }
                    if (!args[0].equalsIgnoreCase("set-default")) break;
                    int argIndex = 0;
                    String modifType = args[argIndex];
                    String varName = args[++argIndex];
                    String value3 = args[++argIndex];
                    Optional<Variable> variableOpt = VariablesManager.getInstance().getVariable(varName);
                    if (variableOpt.isPresent()) {
                        if (modifType.equalsIgnoreCase("set-default")) {
                            variableOpt.get().getDefaultValue().setValue(value3);
                            SendMessage.sendMessageNoPlch(sender, MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.VARIABLE_DEFAULT_VALUE_SET));
                        }
                        VariablesManager.getInstance().updateLoadedMySQL(variableOpt.get().getId(), VariablesManager.MODE.EXPORT);
                        break;
                    }
                    sender.sendMessage(StringConverter.coloredString("&4[SCore] &cVariable (&6" + args[1] + ") &cnot found!"));
                    break;
                }
                if (player == null) break;
                NewSObjectsManagerEditor.getInstance().startEditing(player, new VariablesEditor());
                break;
            }
            case "particles": {
                Optional<Shape> shapeOpt;
                String shapeName = "";
                String targetStr = "";
                String locationStr = "";
                Player targetEntity = null;
                if (player != null) {
                    targetEntity = player;
                }
                Location targetLocation = null;
                for (String arg : args) {
                    if (arg.contains("shape:")) {
                        try {
                            shapeName = arg.split(":")[1];
                        }
                        catch (Exception variableOpt) {}
                        continue;
                    }
                    if (arg.contains("target:")) {
                        try {
                            targetStr = arg.split(":")[1];
                        }
                        catch (Exception variableOpt) {}
                        continue;
                    }
                    if (!arg.contains("location:")) continue;
                    try {
                        locationStr = arg.split(":")[1];
                    }
                    catch (Exception variableOpt) {
                        // empty catch block
                    }
                }
                if (!targetStr.isEmpty()) {
                    try {
                        targetEntity = Bukkit.getEntity((UUID)UUID.fromString(targetStr));
                    }
                    catch (Exception e) {
                        SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cInvalid target (" + targetStr + ") for the command &6/score particles&c.");
                        return;
                    }
                }
                if (targetEntity != null) {
                    targetLocation = targetEntity.getLocation();
                }
                if (!locationStr.isEmpty()) {
                    try {
                        String[] locStr = locationStr.split(",");
                        targetLocation = new Location(AllWorldManager.getWorld(locStr[0]).get(), Double.parseDouble(locStr[1]), Double.parseDouble(locStr[2]), Double.parseDouble(locStr[3]));
                        targetEntity = null;
                    }
                    catch (Exception e) {
                        SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cInvalid location for the command /score particles.");
                        return;
                    }
                }
                if ((shapeOpt = ShapesManager.getInstance().getShape(shapeName)).isPresent()) {
                    Shape shape = shapeOpt.get();
                    shape.getParameters().load(args, (Entity)targetEntity, targetLocation);
                    shape.run(shape.getParameters(), (Entity)targetEntity);
                    SendMessage.sendMessageNoPlch(sender, MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.SHAPE_EXECUTED));
                    break;
                }
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cInvalid shape for the command &6/score particles&c.");
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cShapes: &7" + StringJoiner.join(ShapesManager.getInstance().getShapesNames(), "&8, &7") + "&c.");
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cExample: &6/score particles &eshape:blackhole&c.");
                break;
            }
            case "particles-info": {
                String shapeName2 = "";
                for (String arg : args) {
                    if (!arg.contains("shape:")) continue;
                    try {
                        shapeName2 = arg.split(":")[1];
                    }
                    catch (Exception errorOpt) {
                        // empty catch block
                    }
                }
                Optional<Shape> shapeOpt2 = ShapesManager.getInstance().getShape(shapeName2);
                if (shapeOpt2.isPresent()) {
                    Shape shape = shapeOpt2.get();
                    SendMessage.sendMessageNoPlch(sender, "&2[SCore] &aYou should configure the following parameters for shape &e" + shape.getName() + "&a:");
                    StringBuilder parametersList = new StringBuilder();
                    parametersList.append("&6particle &7type &eclass org.bukkit.Particle\n");
                    for (Parameter parameter : shape.getParameters()) {
                        parametersList.append("&6").append(parameter.getName()).append(" &7type &e").append(parameter.getValue().getClass()).append("\n");
                    }
                    parametersList.append("&7&oFor more info about this shape check &ethe wiki\n\n");
                    SendMessage.sendMessageNoPlch(sender, parametersList.toString());
                    TextComponent link = new TextComponent(StringConverter.coloredString(CenteredMessage.convertIntoCenteredMessage("&a&l[CLICK HERE]")));
                    link.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://docs.ssomar.com/tools-for-all-plugins-score/score-particles"));
                    sender.spigot().sendMessage((BaseComponent)link);
                    sender.sendMessage(" ");
                    Optional<String> exampleOpt = ShapesExamples.getInstance().getExample(shape.getName());
                    if (!exampleOpt.isPresent()) {
                        SendMessage.sendMessageNoPlch(sender, CenteredMessage.convertIntoCenteredMessage("&cNO EXAMPLE AVAILABLE FOR THIS SHAPE"));
                        break;
                    }
                    TextComponent copy = new TextComponent(StringConverter.coloredString(CenteredMessage.convertIntoCenteredMessage("&e&l[CLICK HERE TO COPY THE EXAMPLE]")));
                    copy.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, exampleOpt.get()));
                    sender.spigot().sendMessage((BaseComponent)copy);
                    break;
                }
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cInvalid shape for the command &6/score particles-info&c.");
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cShapes: &7" + StringJoiner.join(ShapesManager.getInstance().getShapesNames(), "&8, &7") + "&c.");
                SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cExample: &6/score particles-info &eshape:blackhole&c.");
                break;
            }
            case "reload": {
                this.main.onReload();
                this.sm.sendMessage(sender, String.valueOf(ChatColor.GREEN) + "SCore has been reloaded.");
                Utils.sendConsoleMsg("SCore reloaded!");
                break;
            }
            case "inspect-loop": {
                Map<SActivator, Integer> loops = LoopManager.getInstance().getLoopActivators();
                this.sm.sendMessage(sender, " ");
                this.sm.sendMessage(sender, "&8==== &7SCore contains &e" + loops.size() + " &7loop(s) &8====");
                this.sm.sendMessage(sender, "&7&o(The loop of ExecutableItems requires more performance when there are many players)");
                this.sm.sendMessage(sender, " ");
                for (SActivator sAct : loops.keySet()) {
                    LoopFeatures loop = null;
                    for (FeatureInterface feature : sAct.getFeatures()) {
                        if (!(feature instanceof LoopFeatures)) continue;
                        loop = (LoopFeatures)feature;
                    }
                    if (loop == null) continue;
                    int delay = (Integer)((Optional)loop.getDelay().getValue()).get();
                    if (!loop.getDelayInTick().getValue().booleanValue()) {
                        delay *= 20;
                    }
                    if (SCore.hasExecutableItems && sAct instanceof ActivatorEIFeature) {
                        this.sm.sendMessage(sender, "&bEI LOOP > &7item: &e" + sAct.getParentObjectId() + " &7delay: &e" + delay + " &7(in ticks)");
                        continue;
                    }
                    if (SCore.hasExecutableBlocks && sAct instanceof ActivatorEBFeature) {
                        this.sm.sendMessage(sender, "&aEB LOOP > &7block: &e" + sAct.getParentObjectId() + " &7delay: &e" + delay + " &7(in ticks)");
                        continue;
                    }
                    if (!SCore.hasExecutableEvents || !(sAct instanceof ActivatorEEFeature)) continue;
                    this.sm.sendMessage(sender, "&6EE LOOP > &7event: &e" + sAct.getParentObjectId() + " &7delay: &e" + delay + " &7(in ticks)");
                }
                this.sm.sendMessage(sender, " ");
                break;
            }
            case "projectiles": {
                if (player == null) break;
                NewSObjectsManagerEditor.getInstance().startEditing(player, new SProjectilesEditor());
                break;
            }
            case "projectiles-create": {
                if (player == null) break;
                if (args.length >= 1) {
                    if (SProjectilesManager.getInstance().getAllObjects().contains(args[0])) {
                        player.sendMessage(StringConverter.coloredString("&4[SCore] &cThis ID already exists! Retype &6/score projectiles-create ID &7&o(ID is the ID you want for your new projectile)&c."));
                        break;
                    }
                    SProjectile sProjectile = new SProjectile(args[0], "plugins/SCore/projectiles/" + args[0] + ".yml");
                    sProjectile.save();
                    SProjectilesManager.getInstance().addLoadedObject(sProjectile);
                    sProjectile.openEditor(player);
                    break;
                }
                player.sendMessage(StringConverter.coloredString("&2[SCore] &aTo create a new projectile, type &e/score projectiles-create ID &7&o(ID is the ID you want for your new projectile)&a."));
                break;
            }
            case "projectiles-delete": {
                if (args.length >= 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cTo confirm deletion, type &6/score projectiles-delete {projID} confirm&c."));
                        return;
                    }
                    Optional sProjectileOpt = SProjectilesManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (sProjectileOpt.isPresent()) {
                        SProjectilesManager.getInstance().deleteObject(args[0]);
                        sender.sendMessage(StringConverter.coloredString("&2[SCore] &aProjectile file (&e" + args[0] + ".yml&a) deleted!"));
                        break;
                    }
                    sender.sendMessage(StringConverter.coloredString("&4[SCore] &cProjectile file (&6" + args[0] + ".yml&c) not found!"));
                    break;
                }
                sender.sendMessage(StringConverter.coloredString("&4[SCore] &cTo confirm deletion, type &6/score projectiles-delete {projID} confirm&c."));
                break;
            }
            case "hardnesses": {
                if (player == null) break;
                NewSObjectsManagerEditor.getInstance().startEditing(player, new HardnessesEditor());
                break;
            }
            case "hardnesses-create": {
                if (player == null) break;
                if (args.length >= 1) {
                    if (HardnessesManager.getInstance().getAllObjects().contains(args[0])) {
                        player.sendMessage(StringConverter.coloredString("&4[SCore] &cThis ID already exists! Retype &6/score hardnesses-create ID &7&o(ID is the ID you want for your new hardness)&c."));
                        break;
                    }
                    Hardness hard = new Hardness(args[0], "plugins/SCore/hardnesses/" + args[0] + ".yml");
                    hard.save();
                    HardnessesManager.getInstance().addLoadedObject(hard);
                    hard.openEditor(player);
                    break;
                }
                player.sendMessage(StringConverter.coloredString("&2[SCore] &aTo create a new hardness, type &e/score hardnesses-create ID &7&o(ID is the ID you want for your new hardness)&a."));
                break;
            }
            case "hardnesses-delete": {
                if (args.length >= 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cTo confirm deletion, type &6/score hardnesses-delete {hardID} confirm&c."));
                        return;
                    }
                    Optional hardnessOpt = HardnessesManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (hardnessOpt.isPresent()) {
                        HardnessesManager.getInstance().deleteObject(args[0]);
                        sender.sendMessage(StringConverter.coloredString("&2[SCore] &aHardness file (&e" + args[0] + ".yml&a) deleted!"));
                        break;
                    }
                    sender.sendMessage(StringConverter.coloredString("&4[SCore] &cHardness file (&6" + args[0] + ".yml&c) not found!"));
                    break;
                }
                sender.sendMessage(StringConverter.coloredString("&4[SCore] &cTo confirm deletion, type &6/score hardnesses-delete {hardID} confirm&c."));
                break;
            }
            case "variables-create": {
                if (player == null) break;
                if (args.length >= 1) {
                    if (VariablesManager.getInstance().getAllObjects().contains(args[0])) {
                        player.sendMessage(StringConverter.coloredString("&4[SCore] &cThis ID already exists! Retype &6/score variables-create ID &7&o(ID is the ID you want for your new variable)&c."));
                        break;
                    }
                    Variable variable = new Variable(args[0], "plugins/SCore/variables/" + args[0] + ".yml");
                    variable.save();
                    VariablesManager.getInstance().addLoadedObject(variable);
                    variable.openEditor(player);
                    break;
                }
                player.sendMessage(StringConverter.coloredString("&2[SCore] &aTo create a new variable, type &e/score variables-create ID &7&o(ID is the ID you want for your new variable)&a."));
                break;
            }
            case "webhook": {
                boolean debug;
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /score webhook <url> <true|false> <message...>");
                    break;
                }
                String webhookUrl = args[0];
                try {
                    debug = Boolean.parseBoolean(args[1]);
                }
                catch (Exception ex) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Second argument must be true or false.");
                    break;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    sb.append(args[i]);
                    if (i >= args.length - 1) continue;
                    sb.append(" ");
                }
                String rawMessage = sb.toString();
                if (debug) {
                    sender.sendMessage("Sending webhook...");
                }
                String escaped = rawMessage.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "");
                String jsonPayload = "{\"content\":\"" + escaped + "\"}";
                Runnable sendWebhook = () -> {
                    boolean success = false;
                    try {
                        URL url = new URL(webhookUrl);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "application/json");
                        conn.setDoOutput(true);
                        byte[] body = jsonPayload.getBytes(StandardCharsets.UTF_8);
                        conn.setFixedLengthStreamingMode(body.length);
                        try (OutputStream os = conn.getOutputStream();){
                            os.write(body);
                        }
                        int responseCode = conn.getResponseCode();
                        conn.disconnect();
                        success = responseCode >= 200 && responseCode < 300;
                    }
                    catch (Exception ex) {
                        success = false;
                    }
                    if (debug) {
                        boolean finalSuccess = success;
                        Bukkit.getScheduler().runTask((Plugin)SCore.plugin, () -> {
                            if (finalSuccess) {
                                sender.sendMessage("Webhook \u00a7asuccessfully sent.\u00a7r");
                            } else {
                                sender.sendMessage("Webhook \u00a7cunsuccessfully sent.\u00a7r");
                            }
                        });
                    }
                };
                SCore.schedulerHook.runAsyncTask(sendWebhook, 0L);
                break;
            }
            case "variables-define": {
                try {
                    File varFile;
                    if (args.length < 3) {
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cCommand format: /score variables-define {var_id} {type} {for} [icon_material] [default_values...]"));
                        return;
                    }
                    Object variablePath = "";
                    if (args[0].contains(".")) {
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cPlease, no \".\" in variable name."));
                        return;
                    }
                    variablePath = "plugins/SCore/variables/" + args[0] + ".yml";
                    Optional<Variable> varOpt = VariablesManager.getInstance().getVariable(args[0]);
                    if (varOpt.isPresent()) {
                        return;
                    }
                    Variable variable = new Variable(args[0], (String)variablePath);
                    List<Object> argList = new ArrayList();
                    if (args.length > 4) {
                        argList = Arrays.asList(Arrays.copyOfRange(args, 4, args.length));
                    }
                    String formattedArgs = String.join((CharSequence)" ", argList);
                    switch (args[1].toLowerCase()) {
                        case "string": {
                            variable.getType().setValue(Optional.of(VariableType.STRING));
                            break;
                        }
                        case "list": {
                            variable.getType().setValue(Optional.of(VariableType.LIST));
                            break;
                        }
                        case "number": {
                            variable.getType().setValue(Optional.of(VariableType.NUMBER));
                            break;
                        }
                        default: {
                            sender.sendMessage(StringConverter.coloredString("&4[SCore] &cYou must pick between STRING, LIST, OR NUMBER for the type! You picked: " + args[1]));
                            return;
                        }
                    }
                    if (args[2].equalsIgnoreCase("global")) {
                        variable.getForFeature().setValue(Optional.of(VariableForEnum.GLOBAL));
                    } else if (args[2].equalsIgnoreCase("player")) {
                        variable.getForFeature().setValue(Optional.of(VariableForEnum.PLAYER));
                    } else {
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cYou must pick between PLAYER or GLOBAL for the scope!"));
                        return;
                    }
                    if (args.length >= 4) {
                        try {
                            variable.getIcon().setValue(Optional.ofNullable(Material.getMaterial((String)args[3].toUpperCase())));
                        }
                        catch (Exception n) {
                            sender.sendMessage(StringConverter.coloredString("&4[SCore] &cInvalid material \"" + args[3] + "\" Check https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html"));
                            return;
                        }
                    }
                    if (!args[1].equalsIgnoreCase("list") && !formattedArgs.isEmpty()) {
                        variable.getDefaultValue().setValue(formattedArgs);
                    }
                    if (!(varFile = new File((String)variablePath)).getParentFile().exists()) {
                        varFile.getParentFile().mkdirs();
                    }
                    if (!varFile.exists()) {
                        varFile.createNewFile();
                    }
                    variable.save();
                    VariablesManager.getInstance().addLoadedObject(variable);
                    sender.sendMessage(StringConverter.coloredString("&2[SCore] &aSuccess defining variable: " + args[0]));
                }
                catch (Exception e) {
                    sender.sendMessage("&4[SCore] &cError defining variable: " + e.getMessage());
                }
                break;
            }
            case "variables-delete": {
                if (args.length >= 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        sender.sendMessage(StringConverter.coloredString("&4[SCore] &cTo confirm deletion, type &6/score variables-delete {varID} confirm&c."));
                        return;
                    }
                    Optional variableOpt = VariablesManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (variableOpt.isPresent()) {
                        VariablesManager.getInstance().deleteObject(args[0]);
                        VariablesManager.getInstance().deleteLoadedMYSQL(args[0]);
                        sender.sendMessage(StringConverter.coloredString("&2[SCore] &aVariable file (&e" + args[0] + ".yml&a) deleted!"));
                        break;
                    }
                    sender.sendMessage(StringConverter.coloredString("&4[SCore] &cVariable file (&6" + args[0] + ".yml&c) not found!"));
                    break;
                }
                sender.sendMessage(StringConverter.coloredString("&4[SCore] &cTo confirm deletion, type &6/score variables-delete {varID} confirm&c."));
                break;
            }
            case "run-player-command": {
                Optional<Object> playerOpt = Optional.empty();
                StringBuilder cmd = new StringBuilder();
                for (String arg : args) {
                    if (arg.startsWith("player:")) {
                        String playerName = arg.replace("player:", "");
                        playerName = StringPlaceholder.replacePlaceholderOfPAPI(playerName, null);
                        try {
                            playerOpt = Optional.ofNullable(Bukkit.getPlayer((UUID)UUID.fromString(playerName)));
                        }
                        catch (Exception e) {
                            playerOpt = Optional.ofNullable(Bukkit.getPlayer((String)playerName));
                        }
                        continue;
                    }
                    cmd.append(arg).append(" ");
                }
                if (!playerOpt.isPresent()) {
                    SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cError: &7&oYou must specify a player with &6player:PLAYER_NAME&7&o or &6player:PLAYER_UUID&c.");
                    return;
                }
                cmd = new StringBuilder(cmd.toString().trim());
                ActionInfo info = new ActionInfo("run-player-command", new StringPlaceholder());
                UUID uuid = ((Player)playerOpt.get()).getUniqueId();
                info.setLauncherUUID(uuid);
                info.setReceiverUUID(uuid);
                StringPlaceholder sp = new StringPlaceholder();
                sp.setPlayerPlcHldr(uuid);
                info.setSp(sp);
                PlayerRunCommandsBuilder builder = new PlayerRunCommandsBuilder(Collections.singletonList(cmd.toString()), info);
                CommandsExecutor.runCommands(builder);
                break;
            }
            case "run-entity-command": {
                Optional<Object> entityOptional = Optional.empty();
                StringBuilder entityCmd = new StringBuilder();
                for (String arg : args) {
                    if (arg.startsWith("entity:")) {
                        String entityName = arg.replace("entity:", "");
                        try {
                            entityOptional = Optional.ofNullable(Bukkit.getEntity((UUID)UUID.fromString(entityName)));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    entityCmd.append(arg).append(" ");
                }
                if (!entityOptional.isPresent()) {
                    SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cError: &7&oYou must specify an entity with &6entity:ENTITY_UUID&c.");
                    return;
                }
                entityCmd = new StringBuilder(entityCmd.toString().trim());
                ActionInfo infoEntity = new ActionInfo("run-entity-command", new StringPlaceholder());
                infoEntity.setEntityUUID(((Entity)entityOptional.get()).getUniqueId());
                infoEntity.setReceiverUUID(((Entity)entityOptional.get()).getUniqueId());
                EntityRunCommandsBuilder entityRunCommandsBuilder = new EntityRunCommandsBuilder(Collections.singletonList(entityCmd.toString()), infoEntity);
                CommandsExecutor.runCommands(entityRunCommandsBuilder);
                break;
            }
            case "run-block-command": {
                Optional<Object> playerOpt2 = Optional.empty();
                Optional<Object> blockOpt = Optional.empty();
                StringBuilder blockCmd = new StringBuilder();
                for (String arg : args) {
                    if (arg.startsWith("player:")) {
                        String playerName = arg.replace("player:", "");
                        try {
                            playerOpt2 = Optional.ofNullable(Bukkit.getPlayer((UUID)UUID.fromString(playerName)));
                        }
                        catch (Exception e) {
                            playerOpt2 = Optional.ofNullable(Bukkit.getPlayer((String)playerName));
                        }
                        continue;
                    }
                    if (arg.startsWith("block:")) {
                        String blockLoc = arg.replace("block:", "");
                        try {
                            String[] loc = blockLoc.split(",");
                            Optional<World> world = AllWorldManager.getWorld(loc[0]);
                            double x = Double.parseDouble(loc[1]);
                            double y = Double.parseDouble(loc[2]);
                            double z = Double.parseDouble(loc[3]);
                            blockOpt = Optional.of(world.get().getBlockAt(new Location(world.get(), x, y, z)));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    blockCmd.append(arg).append(" ");
                }
                if (!blockOpt.isPresent()) {
                    SendMessage.sendMessageNoPlch(sender, "&4[SCore] &cError: &7&oYou must specify a block with &6block:WORLD,X,Y,Z&c.");
                    return;
                }
                blockCmd = new StringBuilder(blockCmd.toString().trim());
                ActionInfo infoBlock = new ActionInfo("run-block-command", new StringPlaceholder());
                Location blockLocation = ((Block)blockOpt.get()).getLocation();
                infoBlock.setBlockLocationX(blockLocation.getBlockX());
                infoBlock.setBlockLocationY(blockLocation.getBlockY());
                infoBlock.setBlockLocationZ(blockLocation.getBlockZ());
                infoBlock.setBlockLocationWorld(blockLocation.getWorld().getUID());
                infoBlock.setOldBlockMaterialName(((Block)blockOpt.get()).getType().name());
                playerOpt2.ifPresent(value -> infoBlock.setLauncherUUID(value.getUniqueId()));
                BlockRunCommandsBuilder blockRunCommandsBuilder = new BlockRunCommandsBuilder(Collections.singletonList(blockCmd.toString()), infoBlock);
                CommandsExecutor.runCommands(blockRunCommandsBuilder);
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        block43: {
            if (!command.getName().equalsIgnoreCase("score")) break block43;
            arguments = new ArrayList<String>();
            if (args.length == 1) {
                arguments.add("clear");
                arguments.add("cooldowns");
                arguments.add("reload");
                arguments.add("inspect-loop");
                arguments.add("projectiles");
                arguments.add("projectiles-create");
                arguments.add("projectiles-delete");
                arguments.add("hardnesses");
                arguments.add("hardnesses-create");
                arguments.add("hardnesses-delete");
                arguments.add("particles");
                arguments.add("particles-info");
                arguments.add("variables");
                arguments.add("variables-create");
                arguments.add("variables-define NAME TYPE SCOPE ICON default arguments...");
                arguments.add("webhook URL debugTrue/False");
                arguments.add("variables-delete");
                arguments.add("run-player-command");
                arguments.add("run-entity-command");
                arguments.add("run-block-command");
                argumentsPerm = new ArrayList<String>();
                for (String str : arguments) {
                    if (!sender.hasPermission("score.cmd." + String.valueOf(command)) && !sender.hasPermission("score.cmds") && !sender.hasPermission("score.*")) continue;
                    argumentsPerm.add(str);
                }
                Collections.sort(argumentsPerm);
                return argumentsPerm.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onTabComplete$3(java.lang.String[] java.lang.String ), (Ljava/lang/String;)Z)((String[])args)).collect(Collectors.toList());
            }
            if (args.length < 2) break block43;
            var6_7 = args[0].toLowerCase();
            var7_9 = -1;
            switch (var6_7.hashCode()) {
                case 250472040: {
                    if (!var6_7.equals("cooldowns")) break;
                    var7_9 = 0;
                    break;
                }
                case -82477705: {
                    if (!var6_7.equals("variables")) break;
                    var7_9 = 1;
                    break;
                }
                case -1933660479: {
                    if (!var6_7.equals("variables-delete")) break;
                    var7_9 = 2;
                    break;
                }
                case -1136846879: {
                    if (!var6_7.equals("run-player-command")) break;
                    var7_9 = 3;
                    break;
                }
                case -2033434909: {
                    if (!var6_7.equals("run-entity-command")) break;
                    var7_9 = 4;
                    break;
                }
                case 1544750665: {
                    if (!var6_7.equals("run-block-command")) break;
                    var7_9 = 5;
                    break;
                }
                case -960339928: {
                    if (!var6_7.equals("hardnesses-delete")) break;
                    var7_9 = 6;
                    break;
                }
                case 185264430: {
                    if (!var6_7.equals("projectiles-delete")) break;
                    var7_9 = 7;
                    break;
                }
                case 94746189: {
                    if (!var6_7.equals("clear")) break;
                    var7_9 = 8;
                }
            }
            switch (var7_9) {
                case 0: {
                    if (args.length == 2) {
                        arguments.add("clear");
                        break;
                    }
                    if (args.length == 3 && args[1].equalsIgnoreCase("clear")) {
                        cooldowns = CooldownsManager.getInstance().getAllCooldownIds();
                        if (cooldowns.isEmpty()) {
                            arguments.add("No cooldowns to clear");
                            break;
                        }
                        arguments.addAll(cooldowns);
                        break;
                    }
                    if (args.length != 4 || !args[1].equalsIgnoreCase("clear")) break;
                    arguments.add("[UUID]");
                    break;
                }
                case 1: {
                    if (args.length == 2) {
                        arguments.add("info");
                        arguments.add("list");
                        arguments.add("set");
                        arguments.add("modification");
                        arguments.add("list-add");
                        arguments.add("list-remove");
                        arguments.add("clear");
                        arguments.add("set-default");
                        break;
                    }
                    if (args.length == 3 && args[1].equalsIgnoreCase("info")) {
                        arguments.addAll(VariablesManager.getInstance().getVariableIdsList());
                        break;
                    }
                    if (args.length == 3 && (args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("modification") || args[1].equalsIgnoreCase("clear") || args[1].equalsIgnoreCase("list-add") || args[1].equalsIgnoreCase("list-remove"))) {
                        arguments.add("global");
                        arguments.add("player");
                        break;
                    }
                    if (args.length == 3 && args[1].equalsIgnoreCase("set-default")) {
                        arguments.addAll(VariablesManager.getInstance().getVariableIdsList());
                        break;
                    }
                    if (args.length != 4 || !args[1].equalsIgnoreCase("set") && !args[1].equalsIgnoreCase("modification") && !args[1].equalsIgnoreCase("clear") && !args[1].equalsIgnoreCase("list-add") && !args[1].equalsIgnoreCase("list-remove")) break;
                    arguments.addAll(VariablesManager.getInstance().getVariableIdsList());
                    break;
                }
                case 2: {
                    if (args.length == 2) {
                        arguments.addAll(VariablesManager.getInstance().getVariableIdsList());
                        break;
                    }
                    if (args.length != 3) break;
                    arguments.add("confirm");
                    break;
                }
                case 3: {
                    if (args.length == 2) {
                        arguments.add("player:");
                        break;
                    }
                    if (args.length != 3 || !args[1].startsWith("player:")) break;
                    arguments.addAll(PlayerCommandManager.getInstance().getCommandsDisplay().values());
                    for (i = 0; i < arguments.size(); ++i) {
                        arg = (String)arguments.get(i);
                        if (arg.length() <= 50) continue;
                        arguments.set(i, arg.substring(0, 45) + "...");
                    }
                    break;
                }
                case 4: {
                    if (args.length == 2) {
                        arguments.add("entity:");
                        break;
                    }
                    if (args.length != 3 || !args[1].startsWith("entity:")) break;
                    arguments.addAll(EntityCommandManager.getInstance().getCommandsDisplay().values());
                    for (i = 0; i < arguments.size(); ++i) {
                        arg = (String)arguments.get(i);
                        if (arg.length() <= 50) continue;
                        arguments.set(i, arg.substring(0, 45) + "...");
                    }
                    break;
                }
                case 5: {
                    if (args.length == 2) {
                        arguments.add("block:");
                        break;
                    }
                    if (args.length != 3 || !args[1].startsWith("block:")) break;
                    arguments.addAll(BlockCommandManager.getInstance().getCommandsDisplay().values());
                    for (i = 0; i < arguments.size(); ++i) {
                        arg = (String)arguments.get(i);
                        if (arg.length() <= 50) continue;
                        arguments.set(i, arg.substring(0, 45) + "...");
                    }
                    break;
                }
                case 6: {
                    if (args.length == 2) {
                        arguments.addAll(HardnessesManager.getInstance().getExecutableBlockIdsList());
                        break;
                    }
                    if (args.length != 3) break;
                    arguments.add("confirm");
                    break;
                }
                case 7: {
                    if (args.length != 2) ** GOTO lbl215
                    arguments.addAll(SProjectilesManager.getInstance().getExecutableBlockIdsList());
                    ** GOTO lbl218
lbl215:
                    // 1 sources

                    if (args.length == 3) {
                        arguments.add("confirm");
                    }
                }
lbl218:
                // 5 sources

                case 8: {
                    if (args.length == 2) {
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            arguments.add(p.getName());
                        }
                        return arguments;
                    }
                    if (args.length != 3) break;
                    for (ClearType type : ClearType.values()) {
                        arguments.add(type.name());
                    }
                    return arguments;
                }
            }
            Collections.sort(arguments);
            return arguments.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onTabComplete$4(java.lang.String[] java.lang.String ), (Ljava/lang/String;)Z)((String[])args)).collect(Collectors.toList());
        }
        return null;
    }

    @Generated
    public CommandsClass(@NotNull SCore main) {
        if (main == null) {
            throw new NullPointerException("main is marked non-null but is null");
        }
        this.main = main;
    }

    private static /* synthetic */ boolean lambda$onTabComplete$4(String[] args, String element) {
        return element.toLowerCase().startsWith(args[args.length - 1].toLowerCase());
    }

    private static /* synthetic */ boolean lambda$onTabComplete$3(String[] args, String element) {
        return element.toLowerCase().startsWith(args[args.length - 1].toLowerCase());
    }
}

