/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.config;

import com.google.common.base.Charsets;
import com.ssomar.score.utils.logging.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Config {
    protected final String fileName;
    protected File pdfile;
    protected FileConfiguration config;
    private Map<String, Object> loadedSettings;

    protected Config(String fileName) {
        this.fileName = fileName;
        this.loadedSettings = new HashMap<String, Object>();
    }

    public void setup(Plugin plugin) {
        this.setup(plugin.getDataFolder(), plugin.getClass().getClassLoader(), plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(File dataFolder, ClassLoader classLoader, @Nullable Plugin plugin) {
        if (!dataFolder.exists()) {
            dataFolder.mkdir();
        }
        this.pdfile = new File(dataFolder, this.fileName);
        if (!this.pdfile.exists()) {
            try {
                this.pdfile.getParentFile().mkdir();
                this.pdfile.createNewFile();
                BufferedReader br = new BufferedReader(new InputStreamReader(Config.getResource(classLoader, this.fileName)));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.pdfile), StandardCharsets.UTF_8));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        out.write(line);
                        out.write("\n");
                    }
                }
                finally {
                    br.close();
                    ((Writer)out).close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create the file: " + this.fileName, e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.pdfile);
        if (this.converter(this.config)) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.pdfile), Charsets.UTF_8);){
                writer.write(this.config.saveToString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (plugin != null) {
            plugin.reloadConfig();
        }
        this.load();
    }

    @Nullable
    public static InputStream getResource(ClassLoader classLoader, @NotNull String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Filename cannot be null or empty");
        }
        try {
            URL url = classLoader.getResource(filename);
            if (url == null) {
                Utils.sendConsoleMsg("&eSCore &7Error while creating the file: &e" + filename + " &7from the plugin jar");
                return null;
            }
            Utils.sendConsoleMsg("&eSCore &7Creating the file: &e" + filename + " &7from the plugin jar (url: &e" + String.valueOf(url) + "&7)");
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            Utils.sendConsoleMsg("&eSCore &7Error while creating the file: &e" + filename + " &7from the plugin jar");
            ex.printStackTrace();
            return null;
        }
    }

    public abstract boolean converter(FileConfiguration var1);

    public abstract void load();

    public void save() {
        try {
            this.config.save(this.pdfile);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe("Could not save " + this.fileName + "!");
        }
    }

    public boolean loadBooleanSetting(String setting, boolean defaultValue) {
        if (!this.config.isBoolean(setting)) {
            this.setBooleanSetting(setting, defaultValue);
        }
        boolean value = this.config.getBoolean(setting, defaultValue);
        this.loadedSettings.put(setting, value);
        return value;
    }

    public void setBooleanSetting(String setting, boolean value) {
        this.loadedSettings.put(setting, value);
        this.config.set(setting, (Object)value);
        this.save();
    }

    public boolean getBooleanSetting(String setting) {
        return (Boolean)this.loadedSettings.get(setting);
    }

    public int loadIntSetting(String setting, int defaultValue) {
        if (!this.config.isInt(setting)) {
            this.setIntSetting(setting, defaultValue);
        }
        int value = this.config.getInt(setting, defaultValue);
        this.loadedSettings.put(setting, value);
        return value;
    }

    public void setIntSetting(String setting, int value) {
        this.loadedSettings.put(setting, value);
        this.config.set(setting, (Object)value);
        this.save();
    }

    public int getIntSetting(String setting, int defaultValue) {
        if (!this.loadedSettings.containsKey(setting)) {
            return defaultValue;
        }
        return (Integer)this.loadedSettings.get(setting);
    }

    public String loadStringSetting(String setting, String defaultValue) {
        if (!this.config.isString(setting)) {
            this.setStringSetting(setting, defaultValue);
        }
        String value = this.config.getString(setting, defaultValue);
        this.loadedSettings.put(setting, value);
        return value;
    }

    public void setStringSetting(String setting, String value) {
        this.loadedSettings.put(setting, value);
        this.config.set(setting, (Object)value);
        this.save();
    }

    public String getStringSetting(String setting, String defaultValue) {
        if (!this.loadedSettings.containsKey(setting)) {
            return defaultValue;
        }
        return (String)this.loadedSettings.get(setting);
    }

    public double loadDoubleSetting(String setting, double defaultValue) {
        if (!this.config.isDouble(setting)) {
            this.setDoubleSetting(setting, defaultValue);
        }
        double value = this.config.getDouble(setting, defaultValue);
        this.loadedSettings.put(setting, value);
        return value;
    }

    public void setDoubleSetting(String setting, double value) {
        this.loadedSettings.put(setting, value);
        this.config.set(setting, (Object)value);
        this.save();
    }

    public double getDoubleSetting(String setting, double defaultValue) {
        if (!this.loadedSettings.containsKey(setting)) {
            return defaultValue;
        }
        return (Double)this.loadedSettings.get(setting);
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public Map<String, Object> getLoadedSettings() {
        return this.loadedSettings;
    }
}

