/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.editor;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.menu.GUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class SaveSessionPathManager {
    private final Map<Player, List<GUI>> playerSessionPath = new HashMap<Player, List<GUI>>();
    private static SaveSessionPathManager instance;

    public void addPlayerSessionPath(Player p, GUI path) {
        if (this.playerSessionPath.containsKey(p)) {
            this.playerSessionPath.get(p).add(path);
        } else {
            this.playerSessionPath.put(p, new ArrayList<GUI>(Collections.singletonList(path)));
        }
        if (this.playerSessionPath.get(p).size() > 12) {
            List<GUI> paths = this.playerSessionPath.get(p);
            ArrayList<GUI> newPaths = new ArrayList<GUI>();
            for (int i = paths.size() - 12; i < paths.size(); ++i) {
                newPaths.add(paths.get(i));
            }
            this.playerSessionPath.put(p, newPaths);
        }
    }

    public void clearPlayerSessionPath(Player p) {
        if (this.playerSessionPath.containsKey(p)) {
            this.playerSessionPath.get(p).clear();
        }
    }

    public GUI getLastPlayerSessionPath(Player p) {
        List<GUI> paths;
        if (this.playerSessionPath.containsKey(p) && (paths = this.playerSessionPath.get(p)).size() > 0) {
            return paths.get(paths.size() - 1);
        }
        return null;
    }

    public GUI getLastBeforePlayerSessionPath(Player p) {
        List<GUI> paths;
        if (this.playerSessionPath.containsKey(p) && (paths = this.playerSessionPath.get(p)).size() > 1) {
            SsomarDev.testMsg("GET GUI > " + String.valueOf(paths.get(paths.size() - 2).getInventory().getHolder()), true);
            return paths.get(paths.size() - 2);
        }
        return null;
    }

    public void removeLastPlayerSessionPath(Player p) {
        List<GUI> paths;
        if (this.playerSessionPath.containsKey(p) && (paths = this.playerSessionPath.get(p)).size() > 1) {
            paths.remove(paths.size() - 1);
        }
    }

    public static SaveSessionPathManager getInstance() {
        if (instance == null) {
            instance = new SaveSessionPathManager();
        }
        return instance;
    }
}

