/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.events.loop;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.events.loop.LoopEvent;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.loop.LoopFeatures;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.OptionGlobal;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class LoopManager {
    private Plugin plugin;
    public int DELAY = 5;
    private static LoopManager instance;
    private final Map<SActivator, Integer> loopActivators;
    private final List<SActivator> loopActivatorsToAdd;
    private final List<SActivator> loopActivatorsToRemove;

    public LoopManager(Plugin plugin) {
        this.plugin = Dependency.SCORE.isInstalled() ? SCore.plugin : plugin;
        this.DELAY = 5;
        if (GeneralConfig.getInstance().isLoopKillMode()) {
            this.DELAY = 1;
        }
        this.loopActivators = new HashMap<SActivator, Integer>();
        this.loopActivatorsToAdd = new ArrayList<SActivator>();
        this.loopActivatorsToRemove = new ArrayList<SActivator>();
        this.runLoop();
    }

    public LoopManager() {
        this.plugin = SCore.plugin;
        this.DELAY = 5;
        if (GeneralConfig.getInstance().isLoopKillMode()) {
            this.DELAY = 1;
        }
        this.loopActivators = new HashMap<SActivator, Integer>();
        this.loopActivatorsToAdd = new ArrayList<SActivator>();
        this.loopActivatorsToRemove = new ArrayList<SActivator>();
        this.runLoop();
    }

    public static LoopManager getInstance(Plugin plugin) {
        if (instance == null) {
            instance = new LoopManager(plugin);
        }
        return instance;
    }

    public static LoopManager getInstance() {
        if (instance == null) {
            instance = new LoopManager();
        }
        return instance;
    }

    public void runLoop() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                ArrayList<Object> toActivate = new ArrayList<Object>();
                ArrayList<SActivator> toRemoveList = new ArrayList<SActivator>();
                toRemoveList.addAll(LoopManager.this.loopActivatorsToAdd);
                toRemoveList.addAll(LoopManager.this.loopActivatorsToRemove);
                Iterator<SActivator> it1 = LoopManager.this.loopActivators.keySet().iterator();
                while (it1.hasNext()) {
                    void var5_5;
                    SActivator activator = it1.next();
                    Object var5_6 = null;
                    for (SActivator toRemove1 : toRemoveList) {
                        if (activator.isEqualsOrAClone(toRemove1)) {
                            SActivator sActivator = toRemove1;
                            it1.remove();
                        }
                        if (var5_5 == null) continue;
                        break;
                    }
                    if (var5_5 != null) {
                        toRemoveList.remove(var5_5);
                        LoopManager.this.loopActivatorsToRemove.remove(var5_5);
                        continue;
                    }
                    LoopFeatures loopFeatures = activator.getLoopFeatures();
                    if (loopFeatures == null) continue;
                    int delay = LoopManager.this.loopActivators.get(activator);
                    if (delay > LoopManager.this.DELAY) {
                        int toRemove = LoopManager.this.DELAY;
                        int newDelay = delay - toRemove;
                        LoopManager.this.loopActivators.put(activator, newDelay);
                        continue;
                    }
                    toActivate.add(activator);
                    if (loopFeatures.getDelayInTick().getValue().booleanValue()) {
                        LoopManager.this.loopActivators.put(activator, (Integer)((Optional)loopFeatures.getDelay().getValue()).get());
                        continue;
                    }
                    LoopManager.this.loopActivators.put(activator, (Integer)((Optional)loopFeatures.getDelay().getValue()).get() * 20);
                }
                for (SActivator sActivator : LoopManager.this.loopActivatorsToAdd) {
                    LoopManager.this.loopActivators.put(sActivator, 0);
                }
                LoopManager.this.loopActivatorsToAdd.clear();
                if (!toActivate.isEmpty()) {
                    ArrayList<SActivator> loopActivators = new ArrayList<SActivator>();
                    for (SActivator sActivator : toActivate) {
                        if (!sActivator.getOption().isLoopOption()) continue;
                        loopActivators.add(sActivator);
                    }
                    LoopEvent loopEvent = new LoopEvent();
                    EventInfo eventInfo = new EventInfo(loopEvent);
                    eventInfo.setOption(OptionGlobal.LOOP);
                    if (!loopActivators.isEmpty()) {
                        while (!loopActivators.isEmpty()) {
                            List<SActivator> extractToActivPerPlugin = ((SActivator)loopActivators.get(0)).extractActivatorsSameClass(loopActivators);
                            eventInfo.setWhitelistActivators(extractToActivPerPlugin);
                            extractToActivPerPlugin.get(0).activateOptionGlobal(eventInfo);
                        }
                    }
                }
            }
        };
        SCore.getSchedulerHook(this.plugin).runRepeatingTask(runnable, 0L, this.DELAY);
    }

    public void addLoopActivator(SActivator activator) {
        if (activator == null) {
            return;
        }
        this.loopActivatorsToAdd.add(activator);
    }

    public void removeLoopActivator(SActivator activator) {
        if (activator == null) {
            return;
        }
        this.loopActivatorsToRemove.add(activator);
    }

    public void resetLoopActivators(SPlugin sPlugin) {
        ArrayList<SActivator> toRemove = new ArrayList<SActivator>();
        for (SActivator sActivator : this.loopActivators.keySet()) {
            if (sActivator.getSPlugin() != sPlugin) continue;
            toRemove.add(sActivator);
        }
        for (SActivator sActivator : toRemove) {
            this.loopActivators.remove(sActivator);
        }
    }

    @Generated
    public Map<SActivator, Integer> getLoopActivators() {
        return this.loopActivators;
    }
}

