/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.utils.emums.ResetSetting;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBlockStateFeature
extends UncoloredStringFeature
implements FeatureForItem {
    private static final boolean DEBUG = false;

    public ItemBlockStateFeature(FeatureParentInterface parent, Optional<String> defaultValue, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, defaultValue, featureSettings, notSaveIfEqualsToDefaultValue);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return args.getMeta() instanceof BlockDataMeta;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        SsomarDev.testMsg("ItemBlockStateFeature applyOnItemMeta: " + String.valueOf(meta), false);
        if (!(((Optional)this.getValue()).isPresent() && this.isAvailable() && this.isApplicable(args))) {
            SsomarDev.testMsg("ItemBlockStateFeature applyOnItemMeta: the value is not present or the meta is not a BlockStateMeta", false);
            return;
        }
        BlockDataMeta blockDataMeta = (BlockDataMeta)meta;
        try {
            BlockData blockData = Bukkit.createBlockData((String)((String)((Optional)this.getValue()).get()));
            blockDataMeta.setBlockData(blockData);
            SsomarDev.testMsg("ItemBlockStateFeature applyOnItemMeta: the blockData is set", false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        SsomarDev.testMsg("ItemBlockStateFeature loadFromItemMeta: " + String.valueOf(meta), true);
        if (this.isAvailable() && this.isApplicable(args)) {
            BlockDataMeta blockDataMeta = (BlockDataMeta)meta;
            if (!blockDataMeta.hasBlockData()) {
                SsomarDev.testMsg("ItemBlockStateFeature loadFromItemMeta: the meta has no blockData", false);
                return;
            }
            ItemStack fakeItem = new ItemStack(args.getMaterial());
            BlockDataMeta fakeBlockData = (BlockDataMeta)fakeItem.getItemMeta();
            String fakeBlockDataStr = fakeBlockData.getBlockData(args.getMaterial()).getAsString(false);
            String[] fakeBlockDataStrSplit = new String[]{};
            try {
                fakeBlockDataStr.split("\\[")[1].replace("]", "").split(",");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String blockData = blockDataMeta.getBlockData(args.getMaterial()).getAsString(true);
            for (String s : fakeBlockDataStrSplit) {
                blockData = blockData.replace("," + s, "");
                blockData = blockData.replace(s + ",", "");
                blockData = blockData.replace(s, "");
            }
            if (blockData.isEmpty()) {
                SsomarDev.testMsg("ItemBlockStateFeature loadFromItemMeta: the blockData is empty", false);
                return;
            }
            SsomarDev.testMsg("ItemBlockStateFeature loadFromItemMeta: the blockData is got " + blockData, false);
            this.setValue(Optional.of(blockData));
        } else {
            SsomarDev.testMsg("ItemBlockStateFeature loadFromItemMeta: the meta is not a BlockDataMeta", false);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.BLOCK_STATE;
    }

    @Override
    public ItemBlockStateFeature clone(FeatureParentInterface newParent) {
        ItemBlockStateFeature clone = new ItemBlockStateFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isNotSaveIfEqualsToDefaultValue());
        clone.setValue((Optional<String>)this.getValue());
        return clone;
    }
}

