/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.utils.emums.ResetSetting;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBlockStatePlusFeature
extends UncoloredStringFeature
implements FeatureForItem {
    private static final boolean DEBUG = false;

    public ItemBlockStatePlusFeature(FeatureParentInterface parent, Optional<String> defaultValue, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, defaultValue, featureSettings, notSaveIfEqualsToDefaultValue);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return args.getMeta() instanceof BlockStateMeta;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        SsomarDev.testMsg("ItemBlockStatePlusFeature applyOnItemMeta: " + String.valueOf(meta), false);
        if (!(((Optional)this.getValue()).isPresent() && this.isAvailable() && this.isApplicable(args))) {
            SsomarDev.testMsg("ItemBlockStatePlusFeature applyOnItemMeta: the value is not present or the meta is not a BlockStateMeta", false);
            return;
        }
        BlockDataMeta blockStateMeta = (BlockDataMeta)meta;
        try {
            SsomarDev.testMsg("ItemBlockStatePlusFeature applyOnItemMeta: the blockData is going to be created " + (String)((Optional)this.getValue()).get(), false);
            BlockData toAdd = Bukkit.createBlockData((String)((String)((Optional)this.getValue()).get()));
            SsomarDev.testMsg("ItemBlockStatePlusFeature applyOnItemMeta: the blockData is created " + String.valueOf(toAdd), false);
            SsomarDev.testMsg("ItemBlockStatePlusFeature applyOnItemMeta: the blockData is create getasstring " + toAdd.getAsString(true), false);
            blockStateMeta.setBlockData(toAdd);
            SsomarDev.testMsg("ItemBlockStatePlusFeature applyOnItemMeta: the blockData is set", false);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        SsomarDev.testMsg("ItemBlockStatePlusFeature loadFromItemMeta: " + String.valueOf(meta), false);
        if (this.isAvailable() && this.isApplicable(args)) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            if (!blockStateMeta.hasBlockState()) {
                SsomarDev.testMsg("ItemBlockStatePlusFeature loadFromItemMeta: the meta has no blockData", false);
                return;
            }
            BlockState blockState = blockStateMeta.getBlockState();
            Container container = (Container)blockState;
            for (ItemStack item : container.getInventory().getContents()) {
                if (item == null) continue;
                if (item.hasItemMeta()) {
                    SsomarDev.testMsg("ItemBlockStatePlusFeature loadFromItemMeta: the item has meta " + item.getItemMeta().getAsString(), false);
                    continue;
                }
                SsomarDev.testMsg("ItemBlockStatePlusFeature loadFromItemMeta: the blockState  no meta is got " + String.valueOf(item.getType()), false);
            }
            String blockData = blockState.getBlockData().getAsString(true);
            if (blockData.isEmpty()) {
                SsomarDev.testMsg("ItemBlockStatePlusFeature loadFromItemMeta: the blockData is empty", false);
                return;
            }
            this.setValue(Optional.of(blockData));
        } else {
            SsomarDev.testMsg("ItemBlockStatePlusFeature loadFromItemMeta: the meta is not a BlockStateMeta", false);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return null;
    }

    @Override
    public ItemBlockStatePlusFeature clone(FeatureParentInterface newParent) {
        ItemBlockStatePlusFeature clone = new ItemBlockStatePlusFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isNotSaveIfEqualsToDefaultValue());
        clone.setValue((Optional<String>)this.getValue());
        return clone;
    }
}

