/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.utils.emums.ResetSetting;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBundleContentFeature
extends ListUncoloredStringFeature
implements FeatureForItem {
    private static final boolean DEBUG = false;

    public ItemBundleContentFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, Optional<List<Suggestion>> suggestions) {
        super(parent, defaultValue, featureSettings, suggestions);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return args.getMeta() instanceof BundleMeta;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        BundleMeta bundleMeta = (BundleMeta)meta;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String value : this.getValues()) {
            ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(value);
            SsomarDev.testMsg("ItemBundleContentFeature applyOnItemMeta: the item " + String.valueOf(item), false);
            items.add(item);
        }
        bundleMeta.setItems(items);
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        SsomarDev.testMsg("ItemBundleContentFeature loadFromItemMeta: " + String.valueOf(meta), false);
        if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            for (ItemStack item : bundleMeta.getItems()) {
                String value = item.hasItemMeta() ? "minecraft:" + item.getType().toString().toLowerCase() + item.getItemMeta().getAsString() : "minecraft:" + item.getType().toString().toLowerCase();
                SsomarDev.testMsg("ItemBundleContentFeature loadFromItemMeta: the item meta " + value, false);
                values.add((CallSite)((Object)value));
            }
        } else {
            SsomarDev.testMsg("ItemBundleContentFeature loadFromItemMeta: the meta is not a BundleMeta", false);
        }
        this.setValues(values);
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.BUNDLE;
    }

    public static byte[] toByteArray(String arrayString) {
        if ((arrayString = arrayString.replace("[", "").replace("]", "").trim()).isEmpty()) {
            return new byte[0];
        }
        String[] byteValues = arrayString.split(",\\s*");
        byte[] bytes = new byte[byteValues.length];
        for (int i = 0; i < byteValues.length; ++i) {
            bytes[i] = Byte.parseByte(byteValues[i]);
        }
        return bytes;
    }

    @Override
    public ItemBundleContentFeature clone(FeatureParentInterface newParent) {
        ItemBundleContentFeature clone = new ItemBundleContentFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), Optional.empty());
        clone.setValues(this.getValues());
        return clone;
    }
}

