/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.bannersettings;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.patterns.group.PatternsGroupFeature;
import com.ssomar.score.features.custom.patterns.subgroup.PatternFeature;
import com.ssomar.score.features.custom.patterns.subpattern.SubPatternFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.ColorIntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BannerSettingsFeature
extends FeatureWithHisOwnEditor<BannerSettingsFeature, BannerSettingsFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private ColorIntegerFeature color;
    private PatternsGroupFeature patterns;

    public BannerSettingsFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.bannerSettings);
        this.reset();
    }

    @Override
    public void reset() {
        this.color = new ColorIntegerFeature(this, Optional.empty(), FeatureSettingsSCore.color);
        this.patterns = new PatternsGroupFeature(this);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection potionSettings = config.getConfigurationSection(this.getName());
            errors.addAll(this.color.load(plugin, potionSettings, isPremiumLoading));
            errors.addAll(this.patterns.load(plugin, potionSettings, isPremiumLoading));
        }
        return errors;
    }

    public void load(SPlugin plugin, ItemStack item, boolean isPremiumLoading) {
        if (item != null && item.hasItemMeta()) {
            this.patterns.load(plugin, item, isPremiumLoading);
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof BlockStateMeta) {
                BlockStateMeta bmeta = (BlockStateMeta)meta;
                Banner banner = (Banner)bmeta.getBlockState();
                this.color.setValue(Optional.of(banner.getBaseColor().getColor().asRGB()));
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection potionSettings = config.createSection(this.getName());
        this.color.save(potionSettings);
        this.patterns.save(potionSettings);
    }

    @Override
    public BannerSettingsFeature getValue() {
        return this;
    }

    @Override
    public BannerSettingsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = ((Optional)this.color.getValue()).isPresent() ? "&7Color : &e" + String.valueOf(((Optional)this.color.getValue()).get()) : "&7Color : &cNO VALUE";
        finalDescription[finalDescription.length - 1] = "&7Pattern(s) : &e" + this.patterns.getMCPatterns().size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public BannerSettingsFeature clone(FeatureParentInterface newParent) {
        BannerSettingsFeature dropFeatures = new BannerSettingsFeature(newParent);
        dropFeatures.color = this.color.clone(dropFeatures);
        dropFeatures.setPatterns(this.patterns.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.color, this.patterns));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BannerSettingsFeature)) continue;
            BannerSettingsFeature hiders = (BannerSettingsFeature)feature;
            hiders.setColor(this.color);
            hiders.setPatterns(this.patterns);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof BannerMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        try {
            BannerMeta bmeta;
            if (meta instanceof BannerMeta) {
                bmeta = (BannerMeta)meta;
                if (!this.getPatterns().getMCPatterns().isEmpty()) {
                    bmeta.setPatterns(this.getPatterns().getMCPatterns());
                }
            }
            if (!SCore.is1v21Plus() && meta instanceof BlockStateMeta && (((Optional)this.getColor().getValue()).isPresent() || !this.getPatterns().getMCPatterns().isEmpty())) {
                DyeColor color;
                bmeta = (BlockStateMeta)meta;
                Banner banner = (Banner)bmeta.getBlockState();
                if (((Optional)this.getColor().getValue()).isPresent() && (color = DyeColor.getByColor((Color)Color.fromRGB((int)((Integer)((Optional)this.getColor().getValue()).get())))) != null) {
                    banner.setBaseColor(color);
                }
                if (!this.getPatterns().getMCPatterns().isEmpty()) {
                    banner.setPatterns(this.getPatterns().getMCPatterns());
                }
                banner.update();
                bmeta.setBlockState((BlockState)banner);
            }
        }
        catch (Exception ignored) {
            SsomarDev.testMsg("Error while applying BannerSettingsFeature on item meta", true);
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        BlockStateMeta bmeta;
        ItemMeta meta = args.getMeta();
        if (meta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            this.patterns.load((SPlugin)SCore.plugin, (ItemMeta)bannerMeta, true);
        } else if (!SCore.is1v21Plus() && meta instanceof BlockStateMeta && (bmeta = (BlockStateMeta)meta).getBlockState() instanceof Banner) {
            Banner banner = (Banner)bmeta.getBlockState();
            this.color.setValue(Optional.of(banner.getBaseColor().getColor().asRGB()));
            int i = 0;
            for (Pattern pattern : banner.getPatterns()) {
                PatternFeature patternFeature = new PatternFeature((FeatureParentInterface)this, "pattern" + i);
                Map map = pattern.serialize();
                int j = 0;
                for (Map.Entry entry : map.entrySet()) {
                    String id = "subpattern" + j;
                    Object value = entry.getValue();
                    SubPatternFeature subPatternFeature = new SubPatternFeature((FeatureParentInterface)patternFeature, id);
                    subPatternFeature.getObject().setValue(value);
                    subPatternFeature.getString().setValue(Optional.ofNullable((String)entry.getKey()));
                    patternFeature.getSubPattern().put(id, subPatternFeature);
                    ++j;
                }
                this.patterns.getPatterns().put("pattern" + ++i, patternFeature);
            }
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.BANNER;
    }

    @Generated
    public ColorIntegerFeature getColor() {
        return this.color;
    }

    @Generated
    public PatternsGroupFeature getPatterns() {
        return this.patterns;
    }

    @Generated
    public void setColor(ColorIntegerFeature color) {
        this.color = color;
    }

    @Generated
    public void setPatterns(PatternsGroupFeature patterns) {
        this.patterns = patterns;
    }
}

