/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.blocksAttacksFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureForItemNewPaperComponents;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.blocksAttacksFeatures.DamageReductionFeatures.group.DamageReductionGroupFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.DamageTypeFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.SoundFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.backward_compatibility.SoundUtils;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.BlocksAttacks;
import io.papermc.paper.registry.tag.TagKey;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BlocksAttacksFeatures
extends FeatureWithHisOwnEditor<BlocksAttacksFeatures, BlocksAttacksFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItemNewPaperComponents {
    private BooleanFeature enable;
    private IntegerFeature blockDelay;
    private SoundFeature blockSound;
    private SoundFeature disableSound;
    private DoubleFeature disableCooldownScale;
    private DamageReductionGroupFeature damageReductions;
    private DamageTypeFeature bypassedBy;

    public BlocksAttacksFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.blockAttacksFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.blockDelay = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.blockDelay);
        this.blockSound = new SoundFeature(this, Optional.empty(), FeatureSettingsSCore.blockSound);
        this.disableSound = new SoundFeature(this, Optional.empty(), FeatureSettingsSCore.disableSound);
        this.disableCooldownScale = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.disableCooldownScale);
        this.damageReductions = new DamageReductionGroupFeature((FeatureParentInterface)this, false);
        this.bypassedBy = new DamageTypeFeature(this, Optional.empty(), FeatureSettingsSCore.bypassedBy);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (FeatureInterface feature : this.getFeatures()) {
                errors.addAll(feature.load(plugin, section, isPremiumLoading));
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public BlocksAttacksFeatures getValue() {
        return this;
    }

    @Override
    public BlocksAttacksFeatures initItemParentEditor(GUI gui, int slot) {
        int len = 8;
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = this.enable.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Disabled: &c&l\u2718";
        finalDescription[finalDescription.length - --len] = "&7Block delay: &e" + String.valueOf(((Optional)this.blockDelay.getValue()).get());
        finalDescription[finalDescription.length - --len] = "&7Block sound: &e" + String.valueOf(((Optional)this.blockSound.getValue()).orElse(null));
        finalDescription[finalDescription.length - --len] = "&7Disable sound: &e" + String.valueOf(((Optional)this.disableSound.getValue()).orElse(null));
        finalDescription[finalDescription.length - --len] = "&7Disable cooldown scale: &e" + String.valueOf(((Optional)this.disableCooldownScale.getValue()).get());
        finalDescription[finalDescription.length - --len] = "&7Damage reductions amount: &e" + this.damageReductions.asList().size();
        finalDescription[finalDescription.length - --len] = "&7Bypassed by: &e" + String.valueOf(((Optional)this.bypassedBy.getValue()).orElse(null));
        --len;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public boolean isAvailable() {
        return SCore.isPaperOrFork() && SCore.is1v21v5Plus() && SCore.hasClass("io.papermc.paper.datacomponent.item.BlocksAttacks") && SCore.hasMethod("io.papermc.paper.datacomponent.item.BlocksAttacks", "damageReductions");
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
    }

    @Override
    public void applyOnItem(@NotNull FeatureForItemArgs args) {
        if (this.isAvailable() && this.enable.getValue().booleanValue()) {
            ItemStack item = args.getItem();
            SsomarDev.testMsg("blockattacks features applyOnItem2", true);
            try {
                item.setData(DataComponentTypes.BLOCKS_ATTACKS, (DataComponentBuilder)BlocksAttacks.blocksAttacks().blockSound(((Optional)this.blockSound.getValue()).isPresent() ? ((Sound)((Optional)this.blockSound.getValue()).get()).getKey() : null).blockDelaySeconds((float)((Integer)((Optional)this.blockDelay.getValue()).get()).intValue()).disableSound(((Optional)this.disableSound.getValue()).isPresent() ? ((Sound)((Optional)this.disableSound.getValue()).get()).getKey() : null).disableCooldownScale(((Double)((Optional)this.disableCooldownScale.getValue()).get()).floatValue()).damageReductions(this.damageReductions.asList()).bypassedBy(((Optional)this.bypassedBy.getValue()).isPresent() ? this.bypassedBy.getValueTagKey() : null));
            }
            catch (Exception e) {
                Utils.sendConsoleMsg(SCore.plugin, "&cError while applying the block attacks features on an item");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadFromItem(@NotNull FeatureForItemArgs args) {
        ItemStack item;
        if (this.isAvailable() && (item = args.getItem()).hasData((DataComponentType)DataComponentTypes.BLOCKS_ATTACKS)) {
            BlocksAttacks blocksAttacks = (BlocksAttacks)item.getData(DataComponentTypes.BLOCKS_ATTACKS);
            this.enable.setValue(true);
            this.blockDelay.setValue(Optional.of((int)blocksAttacks.blockDelaySeconds()));
            this.blockSound.setValue(Optional.ofNullable(SoundUtils.getSound(blocksAttacks.blockSound().value())));
            this.disableSound.setValue(Optional.ofNullable(SoundUtils.getSound(blocksAttacks.disableSound().value())));
            this.disableCooldownScale.setValue(Optional.of(Double.valueOf(blocksAttacks.disableCooldownScale())));
            this.damageReductions.setValues(blocksAttacks.damageReductions());
            this.bypassedBy.setValue((TagKey<DamageType>)blocksAttacks.bypassedBy());
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.BLOCK_ATTACKS;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public BlocksAttacksFeatures clone(FeatureParentInterface newParent) {
        BlocksAttacksFeatures dropFeatures = new BlocksAttacksFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setBlockDelay(this.blockDelay.clone(dropFeatures));
        dropFeatures.setBlockSound(this.blockSound.clone(dropFeatures));
        dropFeatures.setDisableSound(this.disableSound.clone(dropFeatures));
        dropFeatures.setDisableCooldownScale(this.disableCooldownScale.clone(dropFeatures));
        dropFeatures.setDamageReductions(this.damageReductions.clone(dropFeatures));
        dropFeatures.setBypassedBy(this.bypassedBy.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.blockDelay);
        features.add(this.blockSound);
        features.add(this.disableSound);
        features.add(this.disableCooldownScale);
        features.add(this.damageReductions);
        features.add(this.bypassedBy);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BlocksAttacksFeatures)) continue;
            BlocksAttacksFeatures hiders = (BlocksAttacksFeatures)feature;
            hiders.setEnable(this.enable);
            hiders.setBlockDelay(this.blockDelay);
            hiders.setBlockSound(this.blockSound);
            hiders.setDisableSound(this.disableSound);
            hiders.setDisableCooldownScale(this.disableCooldownScale);
            hiders.setDamageReductions(this.damageReductions);
            hiders.setBypassedBy(this.bypassedBy);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public IntegerFeature getBlockDelay() {
        return this.blockDelay;
    }

    @Generated
    public SoundFeature getBlockSound() {
        return this.blockSound;
    }

    @Generated
    public SoundFeature getDisableSound() {
        return this.disableSound;
    }

    @Generated
    public DoubleFeature getDisableCooldownScale() {
        return this.disableCooldownScale;
    }

    @Generated
    public DamageReductionGroupFeature getDamageReductions() {
        return this.damageReductions;
    }

    @Generated
    public DamageTypeFeature getBypassedBy() {
        return this.bypassedBy;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setBlockDelay(IntegerFeature blockDelay) {
        this.blockDelay = blockDelay;
    }

    @Generated
    public void setBlockSound(SoundFeature blockSound) {
        this.blockSound = blockSound;
    }

    @Generated
    public void setDisableSound(SoundFeature disableSound) {
        this.disableSound = disableSound;
    }

    @Generated
    public void setDisableCooldownScale(DoubleFeature disableCooldownScale) {
        this.disableCooldownScale = disableCooldownScale;
    }

    @Generated
    public void setDamageReductions(DamageReductionGroupFeature damageReductions) {
        this.damageReductions = damageReductions;
    }

    @Generated
    public void setBypassedBy(DamageTypeFeature bypassedBy) {
        this.bypassedBy = bypassedBy;
    }
}

