/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.book;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.list.ListColoredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.BookMeta;
import org.jetbrains.annotations.NotNull;

public class BookFeatures
extends FeatureWithHisOwnEditor<BookFeatures, BookFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature enable;
    private ColoredStringFeature author;
    private ColoredStringFeature title;
    private ListColoredStringFeature pages;

    public BookFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.bookFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.author = new ColoredStringFeature(this, Optional.empty(), FeatureSettingsSCore.author);
        this.title = new ColoredStringFeature(this, Optional.empty(), FeatureSettingsSCore.title);
        this.pages = new ListColoredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.pages, Optional.empty());
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            error.addAll(this.enable.load(plugin, section, isPremiumLoading));
            error.addAll(this.title.load(plugin, section, isPremiumLoading));
            error.addAll(this.author.load(plugin, section, isPremiumLoading));
            error.addAll(this.pages.load(plugin, section, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enable.save(section);
        this.title.save(section);
        this.author.save(section);
        this.pages.save(section);
    }

    @Override
    public BookFeatures getValue() {
        return this;
    }

    @Override
    public BookFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 4] = this.enable.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Enabled: &c&l\u2718";
        finalDescription[finalDescription.length - 3] = "&7Title: &e" + ((Optional)this.title.getValue()).orElse("&cNONE");
        finalDescription[finalDescription.length - 2] = "&7Author: &e" + ((Optional)this.author.getValue()).orElse("&cNONE");
        finalDescription[finalDescription.length - 1] = "&7Pages: &e" + this.pages.getValues().size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public BookFeatures clone(FeatureParentInterface newParent) {
        BookFeatures dropFeatures = new BookFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setTitle(this.title.clone(dropFeatures));
        dropFeatures.setAuthor(this.author.clone(dropFeatures));
        dropFeatures.setPages(this.pages.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.title);
        features.add(this.author);
        features.add(this.pages);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BookFeatures)) continue;
            BookFeatures dropFeatures = (BookFeatures)feature;
            dropFeatures.setEnable(this.enable);
            dropFeatures.setTitle(this.title);
            dropFeatures.setAuthor(this.author);
            dropFeatures.setPages(this.pages);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public String getSimpleLocString(Location loc) {
        return loc.getWorld().getName() + "-" + loc.getBlockX() + "-" + loc.getBlockY() + "-" + loc.getBlockZ();
    }

    @Override
    public boolean isAvailable() {
        return !SCore.is1v11Less();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof BookMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (this.isAvailable() && this.isApplicable(args)) {
            BookMeta bookMeta = (BookMeta)args.getMeta();
            if (((Optional)this.getAuthor().getValue()).isPresent()) {
                bookMeta.setAuthor(StringConverter.coloredString((String)((Optional)this.getAuthor().getValue()).get()));
            }
            if (((Optional)this.getTitle().getValue()).isPresent()) {
                bookMeta.setTitle(StringConverter.coloredString((String)((Optional)this.getTitle().getValue()).get()));
            }
            if (!this.getPages().getValue().isEmpty()) {
                ArrayList<String> pages = new ArrayList<String>();
                Iterator iterator = this.getPages().getValue().iterator();
                while (iterator.hasNext()) {
                    String page = (String)iterator.next();
                    pages.add(StringConverter.coloredString(page));
                }
                bookMeta.setPages(pages);
            }
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        if (this.isAvailable() && this.isApplicable(args)) {
            BookMeta bookMeta = (BookMeta)args.getMeta();
            if (bookMeta.hasAuthor()) {
                this.getAuthor().setValue(bookMeta.getAuthor());
            }
            if (bookMeta.hasTitle()) {
                this.getTitle().setValue(bookMeta.getTitle());
            }
            if (!bookMeta.getPages().isEmpty()) {
                ArrayList pages = new ArrayList(bookMeta.getPages());
                this.getPages().setValues(pages);
            }
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.BOOK;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public ColoredStringFeature getAuthor() {
        return this.author;
    }

    @Generated
    public ColoredStringFeature getTitle() {
        return this.title;
    }

    @Generated
    public ListColoredStringFeature getPages() {
        return this.pages;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setAuthor(ColoredStringFeature author) {
        this.author = author;
    }

    @Generated
    public void setTitle(ColoredStringFeature title) {
        this.title = title;
    }

    @Generated
    public void setPages(ListColoredStringFeature pages) {
        this.pages = pages;
    }
}

