/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.commands.console;

import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsExecutor;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.console.ConsoleCommandManager;
import com.ssomar.score.commands.runnable.console.ConsoleRunCommandsBuilder;
import com.ssomar.score.commands.runnable.player.PlayerCommandManager;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.custom.commands.CommandsAbstractFeature;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ConsoleCommandsFeature
extends CommandsAbstractFeature<List<String>, ConsoleCommandsFeature>
implements FeatureRequireSubTextEditorInEditor {
    private List<String> value;
    private boolean notSaveIfEqualsToDefaultValue;

    public ConsoleCommandsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, featureSettings);
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.value = PlayerCommandManager.getInstance().getCommandsVerified(plugin, config.getStringList(this.getName()), errors, this.getParent().getParentInfo());
        if (this.value.isEmpty()) {
            this.value = null;
        }
        return errors;
    }

    public void runCommands(ActionInfo actionInfo, String objectName) {
        if (this.getValue() == null) {
            return;
        }
        ArrayList<String> commands = new ArrayList<String>((Collection<String>)this.getValue());
        ConsoleRunCommandsBuilder builder = new ConsoleRunCommandsBuilder(commands, actionInfo);
        CommandsExecutor.runCommands(builder);
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.notSaveIfEqualsToDefaultValue && (this.value == null || this.value.isEmpty())) {
            config.set(this.getName(), null);
            return;
        }
        config.set(this.getName(), this.value);
    }

    @Override
    public List<String> getValue() {
        if (this.value == null) {
            return new ArrayList<String>();
        }
        return this.value;
    }

    @Override
    public ConsoleCommandsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Your " + this.getEditorName() + ": ";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        ArrayList<String> update = new ArrayList<String>();
        if (this.value != null && !this.value.isEmpty()) {
            int i;
            if (this.value.size() > 10) {
                for (i = 0; i < 10; ++i) {
                    update.add(this.value.get(i));
                }
                update.add("&6... &e" + this.value.size() + " &6commands");
            } else {
                update.addAll(this.value);
            }
            for (i = 0; i < update.size(); ++i) {
                Object command = (String)update.get(i);
                if (((String)command).length() > 40) {
                    command = ((String)command).substring(0, 39) + "...";
                }
                update.set(i, (String)command);
            }
        }
        gui.updateConditionList(this.getEditorName(), update, "&cEMPTY");
    }

    @Override
    public ConsoleCommandsFeature clone(FeatureParentInterface newParent) {
        ConsoleCommandsFeature clone = new ConsoleCommandsFeature(newParent, this.getFeatureSettings(), this.isNotSaveIfEqualsToDefaultValue());
        clone.setValue((List<String>)this.getValue());
        return clone;
    }

    @Override
    public void reset() {
        this.value = null;
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        return ConsoleCommandManager.getInstance().verifCommand(message);
    }

    @Override
    public List<String> getCurrentValues() {
        if (this.getValue() == null) {
            return new ArrayList<String>();
        }
        return this.getValue();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        TextComponent component = new TextComponent(StringConverter.coloredString("&7&oClick here for the utility commands (&e&oDELAY, FOR, LOOP, RANDOM, etc.&7&o)"));
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://docs.ssomar.com/tools-for-all-plugins/custom-commands/utility-commands"));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&7&oClick here for the utility commands (&e&oDELAY, FOR, LOOP, RANDOM, etc.&7&o)")).create()));
        return Collections.singletonList(component);
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (SCommand command : ConsoleCommandManager.getInstance().getCommands()) {
            Suggestion suggestion = new Suggestion(command.getTemplate(), String.valueOf(command.getExtraColorNotNull()) + "[" + String.valueOf(command.getColorNotNull()) + command.getNames().get(0) + String.valueOf(command.getExtraColorNotNull()) + "]", "&7ADD command: &e" + command.getNames().get(0), command.getWikiLink());
            map.put(command.getNames().get(0), suggestion);
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "&c&oJust type your command if it's a console command";
    }

    @Override
    public void sendBeforeTextEditor(Player p, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your commands: (the '/' is useless)");
        HashMap<String, String> commands = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(p), "Console Commands", false, true, true, true, true, true, false, "", commands);
        editor.generateTheMenuAndSendIt(p);
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        this.value = manager.currentWriting.get(editor);
        if (this.value.isEmpty()) {
            this.value = null;
        }
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public boolean isNotSaveIfEqualsToDefaultValue() {
        return this.notSaveIfEqualsToDefaultValue;
    }

    @Generated
    public void setValue(List<String> value) {
        this.value = value;
    }

    @Generated
    public void setNotSaveIfEqualsToDefaultValue(boolean notSaveIfEqualsToDefaultValue) {
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }
}

