/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.commands.entity;

import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsExecutor;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.entity.EntityCommandManager;
import com.ssomar.score.commands.runnable.entity.EntityRunCommandsBuilder;
import com.ssomar.score.commands.runnable.util.commands.DelayTick;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.custom.commands.CommandsAbstractFeature;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class EntityCommandsFeature
extends CommandsAbstractFeature<List<String>, EntityCommandsFeature>
implements FeatureRequireSubTextEditorInEditor {
    private List<String> value;

    public EntityCommandsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.value = EntityCommandManager.getInstance().getCommandsVerified(plugin, config.getStringList(this.getName()), errors, this.getParent().getParentInfo());
        return errors;
    }

    public void runCommands(ActionInfo actionInfo, String objectName) {
        this.runCommands(actionInfo, objectName, false);
    }

    public void runCommands(ActionInfo actionInfo, String objectName, boolean delay1TickTheCommands) {
        List<String> commands = new ArrayList<String>((Collection<String>)this.getValue());
        if (delay1TickTheCommands) {
            commands.add(0, DelayTick.DELAY_TICK_NAMES.get(0) + " 1");
        }
        commands = this.prepareActionbarArgs(commands, objectName);
        EntityRunCommandsBuilder builder2 = new EntityRunCommandsBuilder(commands, actionInfo);
        CommandsExecutor.runCommands(builder2);
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), this.value);
    }

    @Override
    public List<String> getValue() {
        return this.value;
    }

    @Override
    public EntityCommandsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Your " + this.getEditorName() + ": ";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        int i;
        ArrayList<String> update = new ArrayList<String>();
        if (this.value.size() > 10) {
            for (i = 0; i < 10; ++i) {
                update.add(this.value.get(i));
            }
            update.add("&6... &e" + this.value.size() + " &6commands");
        } else {
            update.addAll(this.value);
        }
        for (i = 0; i < update.size(); ++i) {
            Object command = (String)update.get(i);
            if (((String)command).length() > 40) {
                command = ((String)command).substring(0, 39) + "...";
            }
            update.set(i, (String)command);
        }
        gui.updateConditionList(this.getEditorName(), update, "&cEMPTY");
    }

    @Override
    public EntityCommandsFeature clone(FeatureParentInterface newParent) {
        EntityCommandsFeature clone = new EntityCommandsFeature(newParent, this.getFeatureSettings());
        clone.setValue((List<String>)this.getValue());
        return clone;
    }

    @Override
    public void reset() {
        this.value = new ArrayList<String>();
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        return EntityCommandManager.getInstance().verifCommand(message);
    }

    @Override
    public List<String> getCurrentValues() {
        return this.getValue();
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (SCommand command : EntityCommandManager.getInstance().getCommands()) {
            Suggestion suggestion = new Suggestion(command.getTemplate(), String.valueOf(command.getExtraColorNotNull()) + "[" + String.valueOf(command.getColorNotNull()) + command.getNames().get(0) + String.valueOf(command.getExtraColorNotNull()) + "]", "&7ADD command: &e" + command.getNames().get(0), command.getWikiLink());
            map.put(command.getNames().get(0), suggestion);
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        TextComponent component = new TextComponent(StringConverter.coloredString("&7&oClick here for the utility commands (&e&oDELAY, FOR, LOOP, RANDOM, etc.&7&o)"));
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://docs.ssomar.com/tools-for-all-plugins/custom-commands/utility-commands"));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&7&oClick here for the utility commands (&e&oDELAY, FOR, LOOP, RANDOM, etc.&7&o)")).create()));
        return Collections.singletonList(component);
    }

    @Override
    public String getTips() {
        return "&c&oJust type your command if it's a console command";
    }

    @Override
    public void sendBeforeTextEditor(Player p, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your commands: (the '/' is useless)");
        TextComponent variables = new TextComponent(StringConverter.coloredString("&7\u27a4 WIKI of Entity commands: &8&l[CLICK HERE]"));
        variables.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://docs.ssomar.com/tools/custom-commands/entity-commands"));
        variables.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&7&oOpen the wiki")).create()));
        p.spigot().sendMessage((BaseComponent)variables);
        HashMap<String, String> commands = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(p), "Entity Commands", false, true, true, true, true, true, false, "", commands);
        editor.generateTheMenuAndSendIt(p);
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        this.value = manager.currentWriting.get(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public void setValue(List<String> value) {
        this.value = value;
    }
}

