/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.custom.parent;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.custom.CustomConditionFeature;
import com.ssomar.score.features.custom.conditions.custom.CustomConditionRequest;
import com.ssomar.score.features.custom.conditions.custom.condition.IfNotOwnerOfTheEI;
import com.ssomar.score.features.custom.conditions.custom.condition.IfOwnerOfTheEI;
import com.ssomar.score.features.custom.conditions.custom.condition.confirmation.IfNeedPlayerConfirmation;
import com.ssomar.score.features.custom.conditions.custom.parent.CustomConditionsFeatureEditor;
import com.ssomar.score.features.custom.conditions.custom.parent.CustomConditionsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomConditionsFeature
extends FeatureWithHisOwnEditor<CustomConditionsFeature, CustomConditionsFeature, CustomConditionsFeatureEditor, CustomConditionsFeatureEditorManager> {
    private List<CustomConditionFeature> conditions;
    private SPlugin sPlugin;

    public CustomConditionsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, SPlugin sPlugin) {
        super(parent, featureSettings);
        this.sPlugin = sPlugin;
        this.reset();
    }

    @Override
    public void reset() {
        this.conditions = new ArrayList<CustomConditionFeature>();
        this.conditions.add(new IfNeedPlayerConfirmation(this));
        if (this.sPlugin.getShortName().equalsIgnoreCase("ei")) {
            this.conditions.add(new IfOwnerOfTheEI(this));
            this.conditions.add(new IfNotOwnerOfTheEI(this));
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (CustomConditionFeature condition : this.conditions) {
                error.addAll(condition.load(plugin, section, isPremiumLoading));
            }
        }
        return error;
    }

    public boolean verifConditions(Player player, ItemStack itemStack, @NotNull SendMessage messageSender, @Nullable Event event) {
        CustomConditionRequest request = new CustomConditionRequest(player, itemStack, messageSender.getSp(), event);
        for (CustomConditionFeature condition : this.conditions) {
            if (condition.verifCondition(request)) continue;
            if (player != null) {
                for (String error : request.getErrorsFinal()) {
                    messageSender.sendMessage(player, error);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (CustomConditionFeature condition : this.conditions) {
            condition.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public CustomConditionsFeature getValue() {
        return this;
    }

    @Override
    public CustomConditionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7Block condition(s) enabled: &e" + this.getBlockConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public int getBlockConditionEnabledCount() {
        int i = 0;
        for (CustomConditionFeature condition : this.conditions) {
            if (!condition.hasCondition()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public CustomConditionsFeature clone(FeatureParentInterface newParent) {
        CustomConditionsFeature clone = new CustomConditionsFeature(newParent, this.getFeatureSettings(), this.getSPlugin());
        ArrayList<CustomConditionFeature> clones = new ArrayList<CustomConditionFeature>();
        for (CustomConditionFeature condition : this.conditions) {
            clones.add((CustomConditionFeature)condition.clone(clone));
        }
        clone.setConditions(clones);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.conditions);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof CustomConditionsFeature) || !feature.getName().equals(this.getName())) continue;
            CustomConditionsFeature bCF = (CustomConditionsFeature)feature;
            ArrayList<CustomConditionFeature> clones = new ArrayList<CustomConditionFeature>();
            for (CustomConditionFeature condition : this.conditions) {
                clones.add(condition);
            }
            bCF.setConditions(clones);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        CustomConditionsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<CustomConditionFeature> getConditions() {
        return this.conditions;
    }

    @Generated
    public SPlugin getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public void setConditions(List<CustomConditionFeature> conditions) {
        this.conditions = conditions;
    }

    @Generated
    public void setSPlugin(SPlugin sPlugin) {
        this.sPlugin = sPlugin;
    }
}

