/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.placeholders.placeholder;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.commands.console.ConsoleCommandsFeature;
import com.ssomar.score.features.custom.conditions.placeholders.placeholder.PlaceholderConditionFeatureEditor;
import com.ssomar.score.features.custom.conditions.placeholders.placeholder.PlaceholderConditionFeatureEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.ComparatorFeature;
import com.ssomar.score.features.types.PlaceholderConditionTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.Comparator;
import com.ssomar.score.utils.emums.PlaceholdersCdtType;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderConditionFeature
extends FeatureWithHisOwnEditor<PlaceholderConditionFeature, PlaceholderConditionFeature, PlaceholderConditionFeatureEditor, PlaceholderConditionFeatureEditorManager> {
    private static final Boolean DEBUG = true;
    private PlaceholderConditionTypeFeature type;
    private ComparatorFeature comparator;
    private ColoredStringFeature part1;
    private ColoredStringFeature part2;
    private BooleanFeature cancelEventIfNotValid;
    private ColoredStringFeature messageIfNotValid;
    private ColoredStringFeature messageIfNotValidForTarget;
    private BooleanFeature stopCheckingOtherConditionsIfNotValid;
    private ConsoleCommandsFeature consoleCommandsIfError;
    private String id;

    public PlaceholderConditionFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.placeholderCondition);
        this.id = id;
        this.reset();
    }

    public static PlaceholderConditionFeature buildNull() {
        return new PlaceholderConditionFeature(null, "NULL");
    }

    @Override
    public void reset() {
        this.type = new PlaceholderConditionTypeFeature(this, Optional.of(PlaceholdersCdtType.PLAYER_NUMBER), FeatureSettingsSCore.type);
        this.comparator = new ComparatorFeature(this, Optional.of(Comparator.EQUALS), FeatureSettingsSCore.comparator);
        this.part1 = new ColoredStringFeature(this, Optional.of("%player_health%"), FeatureSettingsSCore.part1);
        this.part2 = new ColoredStringFeature(this, Optional.of("10"), FeatureSettingsSCore.part2);
        this.cancelEventIfNotValid = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfNotValid);
        this.messageIfNotValid = new ColoredStringFeature(this, Optional.of(""), FeatureSettingsSCore.messageIfNotValid);
        this.messageIfNotValidForTarget = new ColoredStringFeature(this, Optional.of(""), FeatureSettingsSCore.messageIfNotValidForTarget);
        this.stopCheckingOtherConditionsIfNotValid = new BooleanFeature(this, true, FeatureSettingsSCore.stopCheckingOtherConditionsIfNotValid);
        this.consoleCommandsIfError = new ConsoleCommandsFeature(this, FeatureSettingsSCore.placeholderConditionCmds, true);
    }

    public boolean verify(Player player, Player target) {
        return this.verify(player, target, null);
    }

    public boolean verify(Player player, Player target, @Nullable StringPlaceholder sp) {
        return this.verify((OfflinePlayer)player, target, sp);
    }

    public boolean verify(OfflinePlayer player, Player target, @Nullable StringPlaceholder sp) {
        String aPart1 = "";
        String aPart2 = "";
        PlaceholdersCdtType t = (PlaceholdersCdtType)((Object)((Optional)this.type.getValue()).get());
        if (sp != null) {
            aPart1 = sp.replacePlaceholder((String)((Optional)this.part1.getValue()).get(), false);
            aPart2 = t == PlaceholdersCdtType.PLAYER_TARGET || t == PlaceholdersCdtType.PLAYER_PLAYER || t == PlaceholdersCdtType.TARGET_TARGET ? sp.replacePlaceholder((String)((Optional)this.part2.getValue()).get(), false) : (String)((Optional)this.part2.getValue()).get();
        } else {
            aPart1 = (String)((Optional)this.part1.getValue()).get();
            aPart2 = (String)((Optional)this.part2.getValue()).get();
        }
        if (SCore.hasPlaceholderAPI) {
            if (PlaceholdersCdtType.getpCdtTypeWithPlayer().contains(((Optional)this.type.getValue()).get()) && player != null) {
                aPart1 = StringPlaceholder.replacePlaceholderOfPAPI(aPart1, player.getUniqueId());
            } else if (target != null) {
                aPart1 = StringPlaceholder.replacePlaceholderOfPAPI(aPart1, target.getUniqueId());
            }
            if (PlaceholdersCdtType.PLAYER_PLAYER.equals(((Optional)this.type.getValue()).get()) && player != null) {
                aPart2 = StringPlaceholder.replacePlaceholderOfPAPI(aPart2, player.getUniqueId());
            } else if ((PlaceholdersCdtType.TARGET_TARGET.equals(((Optional)this.type.getValue()).get()) || PlaceholdersCdtType.PLAYER_TARGET.equals(((Optional)this.type.getValue()).get())) && target != null) {
                aPart2 = StringPlaceholder.replacePlaceholderOfPAPI(aPart2, target.getUniqueId());
            }
            if (sp != null) {
                aPart1 = sp.replacePlaceholder(aPart1, false);
                if (t == PlaceholdersCdtType.PLAYER_TARGET || t == PlaceholdersCdtType.PLAYER_PLAYER || t == PlaceholdersCdtType.TARGET_TARGET) {
                    aPart2 = sp.replacePlaceholder(aPart2, false);
                }
            }
            if (t == PlaceholdersCdtType.PLAYER_PLAYER && player == null) {
                aPart1 = StringPlaceholder.replacePlaceholderOfPAPI(aPart1, null);
                aPart2 = StringPlaceholder.replacePlaceholderOfPAPI(aPart2, null);
            }
        }
        aPart1 = StringConverter.deconvertColor(aPart1);
        aPart2 = StringConverter.deconvertColor(aPart2);
        switch (t) {
            case PLAYER_NUMBER: 
            case TARGET_NUMBER: {
                try {
                    if (NTools.isNumber(aPart1)) {
                        double nPart1 = Double.parseDouble(aPart1);
                        double nPart2 = Double.parseDouble(aPart2);
                        if (!((Comparator)((Object)((Optional)this.comparator.getValue()).get())).verify(nPart1, nPart2)) {
                            SsomarDev.testMsg("false because> " + nPart1 + " ?? " + nPart2, DEBUG);
                            return false;
                        }
                        break;
                    }
                    return false;
                }
                catch (Exception e) {
                    Utils.sendConsoleMsg("&cSCore, error with the placeholder condition of the object &6&l" + this.getParentInfo() + " &ccondition: &7" + e.getMessage());
                    return false;
                }
            }
            case PLAYER_STRING: 
            case TARGET_STRING: {
                if (aPart2.contains("<OR>")) {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(aPart2.split("<OR>")));
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, ((String)list.get(i)).trim());
                    }
                    if (((Comparator)((Object)((Optional)this.comparator.getValue()).get())).verify(aPart1, list)) break;
                    return false;
                }
                if (((Comparator)((Object)((Optional)this.comparator.getValue()).get())).verify(aPart1, aPart2)) break;
                SsomarDev.testMsg("false because> " + aPart1 + " ?? " + aPart2, DEBUG);
                return false;
            }
            case PLAYER_PLAYER: 
            case TARGET_TARGET: 
            case PLAYER_TARGET: {
                SsomarDev.testMsg(">>>>>>>>>> aPart1: " + aPart1 + " aPart2: " + aPart2, DEBUG);
                if (NTools.isNumber(aPart1) && NTools.isNumber(aPart2)) {
                    SsomarDev.testMsg("aPart1: " + aPart1 + " aPart2: " + aPart2, DEBUG);
                    double nPart1 = Double.parseDouble(aPart1);
                    double nPart2 = Double.parseDouble(aPart2);
                    if (((Comparator)((Object)((Optional)this.comparator.getValue()).get())).verify(nPart1, nPart2)) break;
                    return false;
                }
                if (((Comparator)((Object)((Optional)this.comparator.getValue()).get())).verify(aPart1, aPart2)) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            String verifNumber;
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.type.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.comparator.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.part1.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.part2.load(plugin, enchantmentConfig, isPremiumLoading));
            if (PlaceholdersCdtType.getpCdtTypeWithNumber().contains(((Optional)this.type.getValue()).get()) && !(verifNumber = (String)((Optional)this.part2.getValue()).get()).contains("%") && !NTools.isNumber(verifNumber)) {
                this.part2.setValue("0");
                errors.add("&cERROR, Couldn't load the Part2 Number value of " + this.getName() + " from config, value: " + verifNumber + " &7&o" + this.getParent().getParentInfo() + " &6>> It must be a placeholder or a number !");
            }
            errors.addAll(this.messageIfNotValid.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.messageIfNotValidForTarget.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.cancelEventIfNotValid.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.stopCheckingOtherConditionsIfNotValid.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.consoleCommandsIfError.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Placeholder Condition with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.type.save(attributeConfig);
        this.comparator.save(attributeConfig);
        this.part1.save(attributeConfig);
        this.part2.save(attributeConfig);
        this.cancelEventIfNotValid.save(attributeConfig);
        this.messageIfNotValid.save(attributeConfig);
        this.messageIfNotValidForTarget.save(attributeConfig);
        this.stopCheckingOtherConditionsIfNotValid.save(attributeConfig);
        this.consoleCommandsIfError.save(attributeConfig);
    }

    @Override
    public PlaceholderConditionFeature getValue() {
        return this;
    }

    @Override
    public PlaceholderConditionFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 6];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 6] = "&7Type: &e" + ((PlaceholdersCdtType)((Object)((Optional)this.type.getValue()).get())).name();
        finalDescription[finalDescription.length - 5] = "&7Comparator: &e" + String.valueOf(((Optional)this.comparator.getValue()).get());
        finalDescription[finalDescription.length - 4] = "&7Part1: &e" + (String)((Optional)this.part1.getValue()).get();
        finalDescription[finalDescription.length - 3] = "&7Part2: &e" + (String)((Optional)this.part2.getValue()).get();
        finalDescription[finalDescription.length - 2] = "&7Console commands If Error: &e" + this.consoleCommandsIfError.getCurrentValues().size();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PlaceholderConditionFeature clone(FeatureParentInterface newParent) {
        PlaceholderConditionFeature eF = new PlaceholderConditionFeature(newParent, this.id);
        eF.setType(this.type.clone(eF));
        eF.setComparator(this.comparator.clone(eF));
        eF.setPart1(this.part1.clone(eF));
        eF.setPart2(this.part2.clone(eF));
        eF.setCancelEventIfNotValid(this.cancelEventIfNotValid.clone(eF));
        eF.setMessageIfNotValid(this.messageIfNotValid.clone(eF));
        eF.setMessageIfNotValidForTarget(this.messageIfNotValidForTarget.clone(eF));
        eF.setStopCheckingOtherConditionsIfNotValid(this.stopCheckingOtherConditionsIfNotValid.clone(eF));
        eF.setConsoleCommandsIfError(this.consoleCommandsIfError.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.type, this.comparator, this.part1, this.part2, this.cancelEventIfNotValid, this.messageIfNotValid, this.messageIfNotValidForTarget, this.stopCheckingOtherConditionsIfNotValid, this.consoleCommandsIfError));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            PlaceholderConditionFeature aFOF;
            if (!(feature instanceof PlaceholderConditionFeature) || !(aFOF = (PlaceholderConditionFeature)feature).getId().equals(this.id)) continue;
            aFOF.setType(this.type);
            aFOF.setComparator(this.comparator);
            aFOF.setPart1(this.part1);
            aFOF.setPart2(this.part2);
            aFOF.setCancelEventIfNotValid(this.cancelEventIfNotValid);
            aFOF.setMessageIfNotValid(this.messageIfNotValid);
            aFOF.setMessageIfNotValidForTarget(this.messageIfNotValidForTarget);
            aFOF.setStopCheckingOtherConditionsIfNotValid(this.stopCheckingOtherConditionsIfNotValid);
            aFOF.setConsoleCommandsIfError(this.consoleCommandsIfError);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        PlaceholderConditionFeatureEditorManager.getInstance().startEditing(player, this);
    }

    public String toString() {
        return "PlaceholderConditionFeature{type=" + String.valueOf(this.type) + ", comparator=" + String.valueOf(this.comparator) + ", part1=" + String.valueOf(this.part1) + ", part2=" + String.valueOf(this.part2) + ", cancelEventIfNotValid=" + String.valueOf(this.cancelEventIfNotValid) + ", messageIfNotValid=" + String.valueOf(this.messageIfNotValid) + ", messageIfNotValidForTarget=" + String.valueOf(this.messageIfNotValidForTarget) + ", stopCheckingOtherConditionsIfNotValid=" + String.valueOf(this.stopCheckingOtherConditionsIfNotValid) + ", id='" + this.id + "'}";
    }

    @Generated
    public PlaceholderConditionTypeFeature getType() {
        return this.type;
    }

    @Generated
    public ComparatorFeature getComparator() {
        return this.comparator;
    }

    @Generated
    public ColoredStringFeature getPart1() {
        return this.part1;
    }

    @Generated
    public ColoredStringFeature getPart2() {
        return this.part2;
    }

    @Generated
    public BooleanFeature getCancelEventIfNotValid() {
        return this.cancelEventIfNotValid;
    }

    @Generated
    public ColoredStringFeature getMessageIfNotValid() {
        return this.messageIfNotValid;
    }

    @Generated
    public ColoredStringFeature getMessageIfNotValidForTarget() {
        return this.messageIfNotValidForTarget;
    }

    @Generated
    public BooleanFeature getStopCheckingOtherConditionsIfNotValid() {
        return this.stopCheckingOtherConditionsIfNotValid;
    }

    @Generated
    public ConsoleCommandsFeature getConsoleCommandsIfError() {
        return this.consoleCommandsIfError;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setType(PlaceholderConditionTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setComparator(ComparatorFeature comparator) {
        this.comparator = comparator;
    }

    @Generated
    public void setPart1(ColoredStringFeature part1) {
        this.part1 = part1;
    }

    @Generated
    public void setPart2(ColoredStringFeature part2) {
        this.part2 = part2;
    }

    @Generated
    public void setCancelEventIfNotValid(BooleanFeature cancelEventIfNotValid) {
        this.cancelEventIfNotValid = cancelEventIfNotValid;
    }

    @Generated
    public void setMessageIfNotValid(ColoredStringFeature messageIfNotValid) {
        this.messageIfNotValid = messageIfNotValid;
    }

    @Generated
    public void setMessageIfNotValidForTarget(ColoredStringFeature messageIfNotValidForTarget) {
        this.messageIfNotValidForTarget = messageIfNotValidForTarget;
    }

    @Generated
    public void setStopCheckingOtherConditionsIfNotValid(BooleanFeature stopCheckingOtherConditionsIfNotValid) {
        this.stopCheckingOtherConditionsIfNotValid = stopCheckingOtherConditionsIfNotValid;
    }

    @Generated
    public void setConsoleCommandsIfError(ConsoleCommandsFeature consoleCommandsIfError) {
        this.consoleCommandsIfError = consoleCommandsIfError;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

