/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.list.ListMaterialFeature;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class IfNotTargetBlock
extends PlayerConditionFeature<ListMaterialFeature, IfNotTargetBlock> {
    public IfNotTargetBlock(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifNotTargetBlock);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            Block block = player.getTargetBlock(null, 5);
            if ((block.getType().equals((Object)Material.WATER) || block.getType().equals((Object)Material.LAVA)) && !block.getBlockData().getAsString().contains("level=0")) {
                this.runInvalidCondition(request);
                return false;
            }
            if (((ListMaterialFeature)this.getCondition()).getValue().contains(block.getType())) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfNotTargetBlock getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListMaterialFeature(this.getParent(), new ArrayList<Material>(), FeatureSettingsSCore.ifNotTargetBlock));
    }

    @Override
    public boolean hasCondition() {
        return ((ListMaterialFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfNotTargetBlock getNewInstance(FeatureParentInterface parent) {
        return new IfNotTargetBlock(parent);
    }
}

