/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.consumableFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureForItemNewPaperComponents;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.ItemUseAnimationFeature;
import com.ssomar.score.features.types.SoundFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ConsumableFeatures
extends FeatureWithHisOwnEditor<ConsumableFeatures, ConsumableFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItemNewPaperComponents {
    private BooleanFeature enable;
    private ItemUseAnimationFeature animation;
    private SoundFeature sound;
    private BooleanFeature consumeParticles;
    private IntegerFeature consumeSeconds;

    public ConsumableFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.consumableFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.animation = new ItemUseAnimationFeature(this, Optional.of(ItemUseAnimation.EAT), FeatureSettingsSCore.animation);
        this.sound = new SoundFeature(this, Optional.empty(), FeatureSettingsSCore.sound);
        this.consumeParticles = new BooleanFeature(this, false, FeatureSettingsSCore.hasConsumeParticles);
        this.consumeSeconds = new IntegerFeature(this, Optional.of(3), FeatureSettingsSCore.consumeSeconds);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.enable.load(plugin, section, isPremiumLoading));
            errors.addAll(this.animation.load(plugin, section, isPremiumLoading));
            errors.addAll(this.sound.load(plugin, section, isPremiumLoading));
            errors.addAll(this.consumeParticles.load(plugin, section, isPremiumLoading));
            errors.addAll(this.consumeSeconds.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enable.save(section);
        this.animation.save(section);
        this.sound.save(section);
        this.consumeParticles.save(section);
        this.consumeSeconds.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public ConsumableFeatures getValue() {
        return this;
    }

    @Override
    public ConsumableFeatures initItemParentEditor(GUI gui, int slot) {
        int len = 6;
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = this.enable.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Disabled: &c&l\u2718";
        finalDescription[finalDescription.length - --len] = "&7Animation: &e" + ((Optional)this.animation.getValue()).orElse(ItemUseAnimation.EAT).name();
        finalDescription[finalDescription.length - --len] = "&7Sound: &e" + String.valueOf(((Optional)this.sound.getValue()).orElse(null));
        finalDescription[finalDescription.length - --len] = this.consumeParticles.getValue() != false ? "&7Consume Particles: &a&l\u2714" : "&7Consume Particles: &c&l\u2718";
        finalDescription[finalDescription.length - --len] = "&7Consume Seconds: &e" + String.valueOf(((Optional)this.consumeSeconds.getValue()).get());
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public void applyOnItemMeta(ItemMeta meta) {
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ConsumableFeatures clone(FeatureParentInterface newParent) {
        ConsumableFeatures dropFeatures = new ConsumableFeatures(newParent);
        dropFeatures.enable = this.enable.clone(dropFeatures);
        dropFeatures.animation = this.animation.clone(dropFeatures);
        dropFeatures.sound = this.sound.clone(dropFeatures);
        dropFeatures.consumeParticles = this.consumeParticles.clone(dropFeatures);
        dropFeatures.consumeSeconds = this.consumeSeconds.clone(dropFeatures);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.animation);
        features.add(this.sound);
        features.add(this.consumeParticles);
        features.add(this.consumeSeconds);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ConsumableFeatures)) continue;
            ConsumableFeatures hiders = (ConsumableFeatures)feature;
            hiders.setEnable(this.enable);
            hiders.setAnimation(this.animation);
            hiders.setSound(this.sound);
            hiders.setConsumeParticles(this.consumeParticles);
            hiders.setConsumeSeconds(this.consumeSeconds);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void applyOnItem(@NotNull FeatureForItemArgs args) {
        ItemStack item = args.getItem();
        try {
            if (!this.enable.getValue().booleanValue()) {
                return;
            }
            Consumable.Builder consumable = Consumable.consumable().animation(((Optional)this.animation.getValue()).orElse(ItemUseAnimation.EAT));
            if (((Optional)this.sound.getValue()).isPresent()) {
                consumable.sound(((Sound)((Optional)this.sound.getValue()).get()).key());
            }
            consumable.hasConsumeParticles(this.consumeParticles.getValue().booleanValue());
            consumable.consumeSeconds((float)((Integer)((Optional)this.consumeSeconds.getValue()).get()).intValue());
            item.setData(DataComponentTypes.CONSUMABLE, (DataComponentBuilder)consumable);
        }
        catch (Exception e) {
            Utils.sendConsoleMsg("&4Error while applying ConsumableFeatures , it's probably due to Paper");
            e.printStackTrace();
        }
    }

    @Override
    public void loadFromItem(@NotNull FeatureForItemArgs args) {
        Consumable consumable = (Consumable)args.getItem().getData(DataComponentTypes.CONSUMABLE);
        if (consumable != null) {
            this.animation.setValue(Optional.of(consumable.animation()));
            this.consumeParticles.setValue(consumable.hasConsumeParticles());
            this.consumeSeconds.setValue(Optional.of(Math.round(consumable.consumeSeconds())));
            this.enable.setValue(true);
        }
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v21v4Plus() && SCore.isPaperOrFork();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.CONSUMABLE;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public ItemUseAnimationFeature getAnimation() {
        return this.animation;
    }

    @Generated
    public SoundFeature getSound() {
        return this.sound;
    }

    @Generated
    public BooleanFeature getConsumeParticles() {
        return this.consumeParticles;
    }

    @Generated
    public IntegerFeature getConsumeSeconds() {
        return this.consumeSeconds;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setAnimation(ItemUseAnimationFeature animation) {
        this.animation = animation;
    }

    @Generated
    public void setSound(SoundFeature sound) {
        this.sound = sound;
    }

    @Generated
    public void setConsumeParticles(BooleanFeature consumeParticles) {
        this.consumeParticles = consumeParticles;
    }

    @Generated
    public void setConsumeSeconds(IntegerFeature consumeSeconds) {
        this.consumeSeconds = consumeSeconds;
    }
}

