/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.container;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForBlock;
import com.ssomar.score.features.FeatureForBlockArgs;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.container.ContainerContent;
import com.ssomar.score.features.custom.container.ContainerOptions;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.list.ListDetailedMaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.block.BlastFurnace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Barrel;
import org.bukkit.block.data.type.BrewingStand;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Crafter;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.block.data.type.Furnace;
import org.bukkit.block.data.type.Hopper;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ContainerFeatures
extends FeatureWithHisOwnEditor<ContainerFeatures, ContainerFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem,
FeatureForBlock {
    private ListDetailedMaterialFeature whitelistMaterials;
    private ListDetailedMaterialFeature blacklistMaterials;
    private BooleanFeature isLocked;
    private UncoloredStringFeature lockedName;
    private ColoredStringFeature inventoryTitle;
    private ContainerContent containerContent;
    private ContainerOptions onlyItemOptions = ContainerOptions.BOTH;

    public ContainerFeatures(FeatureParentInterface parent, ContainerOptions onItemOptions) {
        super(parent, FeatureSettingsSCore.containerFeatures);
        this.onlyItemOptions = onItemOptions;
        this.reset();
    }

    public ContainerFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.containerFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.whitelistMaterials = new ListDetailedMaterialFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.whitelistMaterials, false);
        this.blacklistMaterials = new ListDetailedMaterialFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.blacklistMaterials, false);
        this.isLocked = new BooleanFeature(this, false, FeatureSettingsSCore.isLocked);
        this.lockedName = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.lockedName, false);
        this.inventoryTitle = new ColoredStringFeature(this, Optional.empty(), FeatureSettingsSCore.inventoryTitle);
        this.containerContent = new ContainerContent(this, new ArrayList<String>(), FeatureSettingsSCore.containerContent);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection containerFeaturesSection = config.getConfigurationSection(this.getName());
            error.addAll(this.whitelistMaterials.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.blacklistMaterials.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.isLocked.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.lockedName.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.inventoryTitle.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.containerContent.load(plugin, containerFeaturesSection, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection containerFeaturesSection = config.createSection(this.getName());
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_BLOCK) {
            this.whitelistMaterials.save(containerFeaturesSection);
            this.blacklistMaterials.save(containerFeaturesSection);
            this.inventoryTitle.save(containerFeaturesSection);
        }
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_ITEM) {
            this.isLocked.save(containerFeaturesSection);
            this.lockedName.save(containerFeaturesSection);
            this.containerContent.save(containerFeaturesSection);
        }
    }

    @Override
    public ContainerFeatures getValue() {
        return this;
    }

    @Override
    public ContainerFeatures initItemParentEditor(GUI gui, int slot) {
        int count = 7;
        if (this.onlyItemOptions == ContainerOptions.ONLY_ITEM || this.onlyItemOptions == ContainerOptions.ONLY_BLOCK) {
            count = 4;
        }
        String[] finalDescription = new String[this.getEditorDescription().length + count];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - count] = GUI.CLICK_HERE_TO_CHANGE;
        --count;
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_BLOCK) {
            finalDescription[finalDescription.length - count] = "&7Whitelist size: &e" + this.whitelistMaterials.getValue().size();
            finalDescription[finalDescription.length - --count] = "&7Blacklist size: &e" + this.blacklistMaterials.getValue().size();
            --count;
        }
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_ITEM) {
            finalDescription[finalDescription.length - count] = "&7Is locked: &e" + this.isLocked.getValue();
            finalDescription[finalDescription.length - --count] = "&7Locked name: &e" + ((Optional)this.lockedName.getValue()).orElse("none");
            --count;
        }
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_BLOCK) {
            finalDescription[finalDescription.length - count] = "&7Inventory title: &e" + ((Optional)this.inventoryTitle.getValue()).orElse("none");
            --count;
        }
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_ITEM) {
            finalDescription[finalDescription.length - count] = "&7Container content: &e" + this.containerContent.getValue().size();
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ContainerFeatures clone(FeatureParentInterface newParent) {
        ContainerFeatures eF = new ContainerFeatures(newParent);
        eF.whitelistMaterials = this.whitelistMaterials.clone(eF);
        eF.blacklistMaterials = this.blacklistMaterials.clone(eF);
        eF.isLocked = this.isLocked.clone(eF);
        eF.lockedName = this.lockedName.clone(eF);
        eF.inventoryTitle = this.inventoryTitle.clone(eF);
        eF.containerContent = this.containerContent.clone(eF);
        eF.onlyItemOptions = this.onlyItemOptions;
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_BLOCK) {
            features.add(this.whitelistMaterials);
            features.add(this.blacklistMaterials);
            features.add(this.inventoryTitle);
        }
        if (this.onlyItemOptions == ContainerOptions.BOTH || this.onlyItemOptions == ContainerOptions.ONLY_ITEM) {
            features.add(this.isLocked);
            features.add(this.lockedName);
            features.add(this.containerContent);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ContainerFeatures)) continue;
            ContainerFeatures eF = (ContainerFeatures)feature;
            eF.setWhitelistMaterials(this.whitelistMaterials);
            eF.setBlacklistMaterials(this.blacklistMaterials);
            eF.setIsLocked(this.isLocked);
            eF.setLockedName(this.lockedName);
            eF.setInventoryTitle(this.inventoryTitle);
            eF.setContainerContent(this.containerContent);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForBlockArgs args) {
        BlockData blockData = args.getData();
        if (!SCore.is1v21Plus()) {
            return blockData instanceof Chest || blockData instanceof Hopper || blockData instanceof Furnace || blockData instanceof Dispenser || blockData instanceof BrewingStand || blockData.getMaterial().toString().contains("SHULKER_BOX") || SCore.is1v19Plus() && blockData instanceof Barrel || blockData instanceof Smoker || blockData instanceof BlastFurnace || SCore.is1v20v4Plus() && blockData instanceof Crafter;
        }
        return args.getBlockState() instanceof Container;
    }

    @Override
    public void applyOnBlockData(@NotNull FeatureForBlockArgs args) {
        if (!this.isApplicable(args)) {
            return;
        }
        Container container = (Container)args.getBlockState();
        if (((Optional)this.getInventoryTitle().getValue()).isPresent()) {
            String title = (String)((Optional)this.getInventoryTitle().getValue()).get();
            container.setCustomName(StringConverter.coloredString(title));
        }
        if (this.getIsLocked().getValue().booleanValue() && ((Optional)this.getLockedName().getValue()).isPresent()) {
            container.setLock((String)((Optional)this.getLockedName().getValue()).get());
        }
        container.update();
        this.containerContent.applyOnBlockData(args);
    }

    @Override
    public void loadFromBlockData(@NotNull FeatureForBlockArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        Container container = (Container)args.getBlockState();
        if (container.getCustomName() != null) {
            this.getInventoryTitle().setValue(StringConverter.decoloredString(container.getCustomName()));
        }
        if (container.isLocked()) {
            this.getIsLocked().setValue(true);
            this.getLockedName().setValue(Optional.of(container.getLock()));
        }
        this.containerContent.loadFromBlockData(args);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        if (!SCore.is1v20v4Plus() || !(meta instanceof BlockStateMeta)) {
            return false;
        }
        BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
        return blockStateMeta.getBlockState() instanceof Container;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        this.containerContent.applyOnItemMeta(args);
        if (this.isLocked.getValue().booleanValue() && ((Optional)this.lockedName.getValue()).isPresent()) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)args.getMeta();
            Container container = (Container)blockStateMeta.getBlockState();
            if (SCore.is1v21v2Plus()) {
                try {
                    ItemStack item = Bukkit.getServer().getItemFactory().createItemStack((String)((Optional)this.lockedName.getValue()).get());
                    container.setLockItem(item);
                }
                catch (Exception e) {
                    container.setLock((String)((Optional)this.lockedName.getValue()).get());
                }
            } else {
                container.setLock((String)((Optional)this.lockedName.getValue()).get());
            }
            container.update();
            blockStateMeta.setBlockState((BlockState)container);
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        this.containerContent.loadFromItemMeta(args);
        BlockStateMeta blockStateMeta = (BlockStateMeta)args.getMeta();
        Container container = (Container)blockStateMeta.getBlockState();
        if (container.isLocked()) {
            this.isLocked.setValue(true);
            this.lockedName.setValue(Optional.of(container.getLock()));
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.CONTAINER;
    }

    @Generated
    public ListDetailedMaterialFeature getWhitelistMaterials() {
        return this.whitelistMaterials;
    }

    @Generated
    public ListDetailedMaterialFeature getBlacklistMaterials() {
        return this.blacklistMaterials;
    }

    @Generated
    public BooleanFeature getIsLocked() {
        return this.isLocked;
    }

    @Generated
    public UncoloredStringFeature getLockedName() {
        return this.lockedName;
    }

    @Generated
    public ColoredStringFeature getInventoryTitle() {
        return this.inventoryTitle;
    }

    @Generated
    public ContainerContent getContainerContent() {
        return this.containerContent;
    }

    @Generated
    public ContainerOptions getOnlyItemOptions() {
        return this.onlyItemOptions;
    }

    @Generated
    public void setWhitelistMaterials(ListDetailedMaterialFeature whitelistMaterials) {
        this.whitelistMaterials = whitelistMaterials;
    }

    @Generated
    public void setBlacklistMaterials(ListDetailedMaterialFeature blacklistMaterials) {
        this.blacklistMaterials = blacklistMaterials;
    }

    @Generated
    public void setIsLocked(BooleanFeature isLocked) {
        this.isLocked = isLocked;
    }

    @Generated
    public void setLockedName(UncoloredStringFeature lockedName) {
        this.lockedName = lockedName;
    }

    @Generated
    public void setInventoryTitle(ColoredStringFeature inventoryTitle) {
        this.inventoryTitle = inventoryTitle;
    }

    @Generated
    public void setContainerContent(ContainerContent containerContent) {
        this.containerContent = containerContent;
    }

    @Generated
    public void setOnlyItemOptions(ContainerOptions onlyItemOptions) {
        this.onlyItemOptions = onlyItemOptions;
    }
}

